package com.ejie.y41a.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CampahnaRecib;
import com.ejie.y41a.model.CampahnaRecibBusqueda;
import com.ejie.y41a.model.Campanha;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.service.CampahnaRecibService;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * * CampahnaRecibController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/campahnarecib")
public class CampahnaRecibController {

	private static final Logger logger = LoggerFactory
			.getLogger(CampahnaRecibController.class);

	@Autowired()
	private CampahnaRecibService campahnaRecibService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("campahnarecib", "model", model);
	}

	/**
	 * Method 'getCreateFormCampania'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "detalleCampania", method = RequestMethod.GET)
	public ModelAndView getCreateFormCampania(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("detalleCampania", "model", model);
	}

	/**
	 * Method 'getCreateFormAlarma'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "detalleAlerta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlerta(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("detalleAlerta", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param s4codigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{s4codigo}", method = RequestMethod.GET)
	public @ResponseBody()
	CampahnaRecib getById(@PathVariable() String s4codigo) {
		try {
			CampahnaRecib campahnaRecib = new CampahnaRecib();
			campahnaRecib.setS4codigo(s4codigo);
			campahnaRecib = this.campahnaRecibService.find(campahnaRecib);
			if (campahnaRecib == null) {
				throw new Exception(s4codigo.toString());
			}
			return campahnaRecib;
		} catch (Exception e) {
			throw new ResourceNotFoundException(s4codigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param s4codigo
	 *            String
	 * @param campanhaCmcodigo
	 *            String
	 * @param s4codorganismo
	 *            String
	 * @param s4feccomunicacion
	 *            Date
	 * @param s4fecfinalizacion
	 *            Date
	 * @param s4cantidadactuaciones
	 *            Integer
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "s4codigo", required = false) String s4codigo,
			@RequestParam(value = "campanhaCmcodigo", required = false) String campanhaCmcodigo,
			@RequestParam(value = "s4codorganismo", required = false) String s4codorganismo,
			@RequestParam(value = "s4feccomunicacion", required = false) Date s4feccomunicacion,
			@RequestParam(value = "s4fecfinalizacion", required = false) Date s4fecfinalizacion,
			@RequestParam(value = "s4cantidadactuaciones", required = false) Integer s4cantidadactuaciones,
			HttpServletRequest request) {
		try {
			CampahnaRecib filterCampahnaRecib = new CampahnaRecib(s4codigo,
					s4codorganismo, s4feccomunicacion, s4fecfinalizacion,
					s4cantidadactuaciones, new Campanha(campanhaCmcodigo, null,
							null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<CampahnaRecib> campahnaRecibs = this.campahnaRecibService
						.findAll(filterCampahnaRecib, pagination);

				if (campahnaRecibs == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterCampahnaRecib, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(campahnaRecibs);
				return data;
			} else {
				List<CampahnaRecib> campahnaRecibs = this.campahnaRecibService
						.findAll(filterCampahnaRecib, pagination);
				if (campahnaRecibs == null) {
					throw new Exception("No data Found.");
				}
				return campahnaRecibs;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCampania'.
	 * 
	 * @param tipo_
	 *            String
	 * @param codigo
	 *            String
	 * @param descripcion_
	 *            String
	 * @param numInspecciones
	 *            Integer
	 * @param fecrecepcion
	 *            Date
	 * @param fecfinalizacion
	 *            Date
	 * @param codOrganismo
	 *            String
	 * @param codigoRecibida
	 *            String
	 * @param codigoDetalle
	 *            String
	 * @param fecrecepcionDesde_
	 *            Date
	 * @param fecrecepcionHasta_
	 *            Date
	 * @param mostrarFinalizadas_
	 *            Integer
	 * @param situacion
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/buscarCampania", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllCampania(
			@RequestParam(value = "tipo", required = false) String tipo_,
			@RequestParam(value = "codigo", required = false) String codigo,
			@RequestParam(value = "descripcion", required = false) String descripcion_,
			@RequestParam(value = "numInspecciones", required = false) Integer numInspecciones,
			@RequestParam(value = "fecrecepcion", required = false) String fecrecepcion,
			@RequestParam(value = "fecfinalizacion", required = false) String fecfinalizacion,
			@RequestParam(value = "codOrganismo", required = false) String codOrganismo,
			@RequestParam(value = "codigoRecibida", required = false) String codigoRecibida,
			@RequestParam(value = "codigoDetalle", required = false) String codigoDetalle,
			@RequestParam(value = "fecrecepcionDesde", required = false) String fecrecepcionDesde_,
			@RequestParam(value = "fecrecepcionHasta", required = false) String fecrecepcionHasta_,
			@RequestParam(value = "mostrarFinalizadas", required = false) String mostrarFinalizadas_,
			@RequestParam(value = "situacion", required = false) String situacion,
			HttpServletRequest request) {
		try {

			// control de los campos susceptibles de llegar a "" desde el filtro

			String tipo = ("".equals(tipo_)) ? null : tipo_;
			String descripcion = ("".equals(descripcion_)) ? null
					: descripcion_;

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date fecrecepcionDesde = Y41aUtils.parseDate(fecrecepcionDesde_,
					locale);
			Date fecrecepcionHasta = Y41aUtils.parseDate(fecrecepcionHasta_,
					locale);

			// control checks
			String mostrarFinalizadas = ("on".equals(mostrarFinalizadas_)) ? Y41aConstantes.SI
					: null;

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			CampahnaRecibBusqueda filterCampahnaBusqueda = new CampahnaRecibBusqueda(
					tipo, null, descripcion, null, null, null, censoMonitor
							.getOrganismo().getCodOrg(), null, null,
					fecrecepcionDesde, fecrecepcionHasta, mostrarFinalizadas,
					null);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<CampahnaRecibBusqueda> campahnaRecibBusqueda = this.campahnaRecibService
						.findAllLikeCampahna(filterCampahnaBusqueda,
								pagination, false);

				if (campahnaRecibBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountBusqueda(filterCampahnaBusqueda,
						request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(campahnaRecibBusqueda);
				return data;
			} else {
				List<CampahnaRecibBusqueda> campahnaRecibsBusqueda = this.campahnaRecibService
						.findAllLikeCampahna(filterCampahnaBusqueda,
								pagination, false);

				if (campahnaRecibsBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return campahnaRecibsBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getPendientesAll'. Bandeja de escritorio
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/pendientes", method = RequestMethod.GET)
	public @ResponseBody()
	List<CampahnaRecibBusqueda> getPendientesAll(HttpServletRequest request) {
		try {

			HttpSession httpSession = request.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			String codOrganismo = censoMonitor.getOrganismo().getCodOrg();

			CampahnaRecibBusqueda filterCampahnaBusqueda = new CampahnaRecibBusqueda();
			// código organismo conectado
			filterCampahnaBusqueda.setCodOrganismo(codOrganismo);

			Pagination pagination = new Pagination();
			pagination.setSort("fecrecepcion");
			pagination.setAscDsc(Y41aConstantes.ORDENACION_DESC);

			// Es un método nuevo para la bandeja de escritorio
			List<CampahnaRecibBusqueda> campahnaRecibBusqueda = this.campahnaRecibService
					.findAllLikeCampahnaSinActuaciones(filterCampahnaBusqueda,
							pagination);

			return campahnaRecibBusqueda;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountBusqueda'.
	 * 
	 * @param filterCampahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCountBusqueda(
			@RequestParam(value = "campahnaRecibBusqueda", required = false) CampahnaRecibBusqueda filterCampahnaRecibBusqueda,
			HttpServletRequest request) {
		try {
			return this.campahnaRecibService
					.findAllLikeCampahnaCount(
							filterCampahnaRecibBusqueda != null ? filterCampahnaRecibBusqueda
									: new CampahnaRecibBusqueda(), false);
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterCampahnaRecib
	 *            CampahnaRecib
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@RequestParam(value = "campahnaRecib", required = false) CampahnaRecib filterCampahnaRecib,
			HttpServletRequest request) {
		try {
			return this.campahnaRecibService
					.findAllCount(filterCampahnaRecib != null ? filterCampahnaRecib
							: new CampahnaRecib());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param campahnaRecib
	 *            CampahnaRecib
	 * @param response
	 *            HttpServletResponse
	 * @return CampahnaRecib
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	CampahnaRecib edit(@RequestBody() CampahnaRecib campahnaRecib,
			HttpServletResponse response) {
		try {
			CampahnaRecib campahnaRecibAux = this.campahnaRecibService
					.update(campahnaRecib);
			logger.info("Entity correctly inserted!");
			return campahnaRecibAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editFinalizar'.
	 * 
	 * @param codigo
	 *            String
	 * @param tipo
	 *            String
	 * @return CampahnaRecib
	 */
	@RequestMapping(value = "/finalizarCampahna", method = RequestMethod.PUT)
	public @ResponseBody()
	CampahnaRecibBusqueda editFinalizar(
			@RequestParam(value = "codigo", required = true) String codigo,
			@RequestParam(value = "tipo", required = false) String tipo) {

		try {
			CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
			campahnaRecibBusqueda.setCodigoRecibida(codigo);
			campahnaRecibBusqueda.setTipo(tipo);

			CampahnaRecibBusqueda campahnaRecibBusquedaAux = this.campahnaRecibService
					.updateCampahna(campahnaRecibBusqueda);
			logger.info("Entity correctly inserted!");
			return campahnaRecibBusquedaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param campahnaRecib
	 *            CampahnaRecib
	 * @return CampahnaRecib
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	CampahnaRecib add(@RequestBody() CampahnaRecib campahnaRecib) {
		try {
			CampahnaRecib campahnaRecibAux = this.campahnaRecibService
					.add(campahnaRecib);
			logger.info("Entity correctly inserted!");
			return campahnaRecibAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param s4codigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{s4codigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String s4codigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			CampahnaRecib campahnaRecib = new CampahnaRecib();
			campahnaRecib.setS4codigo(s4codigo);
			this.campahnaRecibService.remove(campahnaRecib);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + s4codigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param campahnaRecibIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody() ArrayList<ArrayList<String>> campahnaRecibIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<CampahnaRecib> campahnaRecibList = new ArrayList<CampahnaRecib>();
		try {
			for (ArrayList<String> campahnaRecibId : campahnaRecibIds) {
				Iterator<String> iterator = campahnaRecibId.iterator();
				CampahnaRecib campahnaRecib = new CampahnaRecib();
				campahnaRecib.setS4codigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				campahnaRecibList.add(campahnaRecib);
			}
			this.campahnaRecibService.removeMultiple(campahnaRecibList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getCampahnaRecibService'.
	 * 
	 * @return CampahnaRecibService
	 */
	protected CampahnaRecibService getCampahnaRecibService() {
		return this.campahnaRecibService;
	}

	/**
	 * Method 'setCampahnaRecibService'.
	 * 
	 * @param campahnaRecibService
	 *            CampahnaRecibService
	 * @return
	 */
	public void setCampahnaRecibService(
			CampahnaRecibService campahnaRecibService) {
		this.campahnaRecibService = campahnaRecibService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
