package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.AnalisisDetalle;
import com.ejie.y41a.model.OriProdAlerta;
import com.ejie.y41a.model.TipCaracMuestra;
import com.ejie.y41a.model.TipDepoMuestra;
import com.ejie.y41a.service.AnalisisService;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Analisis;

/**
 * * AnalisisController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/analisis")
public class AnalisisController {

	private static final Logger logger = LoggerFactory
			.getLogger(AnalisisController.class);

	@Autowired
	private AnalisisService analisisService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("analisis", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ancodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{ancodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Analisis getById(@PathVariable String ancodigo) {
		try {
			Analisis analisis = new Analisis();
			analisis.setAncodigo(ancodigo);
			analisis = this.analisisService.find(analisis);
			if (analisis == null) {
				throw new Exception(ancodigo.toString());
			}
			return analisis;
		} catch (Exception e) {
			throw new ResourceNotFoundException(ancodigo.toString());
		}
	}

	/**
	 * Method 'getByIdMuestra'.
	 * 
	 * @param atcodigo
	 *            String
	 * @return AnalisisDetalle
	 */
	@RequestMapping(value = "/buscarMuestra", method = RequestMethod.GET)
	public @ResponseBody
	AnalisisDetalle getByIdMuestra(
			@RequestParam(value = "atcodigo", required = true) String atcodigo) {
		try {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			AnalisisDetalle analisisDetalle = new AnalisisDetalle();
			Analisis analisis = new Analisis();

			analisis.setActuacion(actuacion);
			analisisDetalle = this.analisisService.findMuestra(analisis);
			if (analisisDetalle == null) {
				throw new Exception(atcodigo.toString());
			}
			return analisisDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(atcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param ancodigo
	 *            String
	 * @param tipCaracMuestraTctcodigo
	 *            String
	 * @param tipDepoMuestraTdmcodigo
	 *            String
	 * @param actuacionAtcodigo
	 *            String
	 * @param oriProdAlertaTomcodigo
	 *            String
	 * @param ancohd
	 *            String
	 * @param annrmu
	 *            Integer
	 * @param annran
	 *            BigDecimal
	 * @param ancoor
	 *            String
	 * @param anteestm
	 *            String
	 * @param ancaptpm
	 *            BigDecimal
	 * @param ancola
	 *            String
	 * @param antedeas
	 *            String
	 * @param anfereel
	 *            Date
	 * @param annrboan
	 *            String
	 * @param anfeboan
	 *            Date
	 * @param anteinba
	 *            String
	 * @param anfecrar
	 *            Date
	 * @param aninexac
	 *            String
	 * @param aninexad
	 *            String
	 * @param anfecoac
	 *            Date
	 * @param aninreac
	 *            String
	 * @param aninlaci
	 *            String
	 * @param anfeceac
	 *            Date
	 * @param anfeenac
	 *            Date
	 * @param anfeboac
	 *            Date
	 * @param aninrsac
	 *            String
	 * @param anferbac
	 *            Date
	 * @param anfeerac
	 *            Date
	 * @param anfesoad
	 *            Date
	 * @param anfeboad
	 *            Date
	 * @param aninread
	 *            String
	 * @param anfecora
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "ancodigo", required = false) String ancodigo,
			@RequestParam(value = "tipCaracMuestraTctcodigo", required = false) String tipCaracMuestraTctcodigo,
			@RequestParam(value = "tipDepoMuestraTdmcodigo", required = false) String tipDepoMuestraTdmcodigo,
			@RequestParam(value = "actuacionAtcodigo", required = false) String actuacionAtcodigo,
			@RequestParam(value = "oriProdAlertaTomcodigo", required = false) String oriProdAlertaTomcodigo,
			@RequestParam(value = "ancohd", required = false) String ancohd,
			@RequestParam(value = "annrmu", required = false) Integer annrmu,
			@RequestParam(value = "annran", required = false) BigDecimal annran,
			@RequestParam(value = "ancoor", required = false) String ancoor,
			@RequestParam(value = "anteestm", required = false) String anteestm,
			@RequestParam(value = "ancaptpm", required = false) BigDecimal ancaptpm,
			@RequestParam(value = "ancola", required = false) String ancola,
			@RequestParam(value = "antedeas", required = false) String antedeas,
			@RequestParam(value = "anfereel", required = false) Date anfereel,
			@RequestParam(value = "annrboan", required = false) String annrboan,
			@RequestParam(value = "anfeboan", required = false) Date anfeboan,
			@RequestParam(value = "anteinba", required = false) String anteinba,
			@RequestParam(value = "anfecrar", required = false) Date anfecrar,
			@RequestParam(value = "aninexac", required = false) String aninexac,
			@RequestParam(value = "aninexad", required = false) String aninexad,
			@RequestParam(value = "anfecoac", required = false) Date anfecoac,
			@RequestParam(value = "aninreac", required = false) String aninreac,
			@RequestParam(value = "aninlaci", required = false) String aninlaci,
			@RequestParam(value = "anfeceac", required = false) Date anfeceac,
			@RequestParam(value = "anfeenac", required = false) Date anfeenac,
			@RequestParam(value = "anfeboac", required = false) Date anfeboac,
			@RequestParam(value = "aninrsac", required = false) String aninrsac,
			@RequestParam(value = "anferbac", required = false) Date anferbac,
			@RequestParam(value = "anfeerac", required = false) Date anfeerac,
			@RequestParam(value = "anfesoad", required = false) Date anfesoad,
			@RequestParam(value = "anfeboad", required = false) Date anfeboad,
			@RequestParam(value = "aninread", required = false) String aninread,
			@RequestParam(value = "anfecora", required = false) Date anfecora,
			HttpServletRequest request) {
		try {
			Analisis filterAnalisis = new Analisis(ancodigo, ancohd, annrmu,
					annran, ancoor, anteestm, ancaptpm, ancola, antedeas,
					anfereel, annrboan, anfeboan, anteinba, anfecrar, aninexac,
					aninexad, anfecoac, aninreac, aninlaci, anfeceac, anfeenac,
					anfeboac, aninrsac, anferbac, anfeerac, anfesoad, anfeboad,
					aninread, anfecora, new TipCaracMuestra(
							tipCaracMuestraTctcodigo, null, null),
					new TipDepoMuestra(tipDepoMuestraTdmcodigo, null, null),
					new Actuacion(actuacionAtcodigo, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null), new OriProdAlerta(
							oriProdAlertaTomcodigo, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Analisis> analisiss = this.analisisService.findAll(
						filterAnalisis, pagination);

				if (analisiss == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterAnalisis, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(analisiss);
				return data;
			} else {
				List<Analisis> analisiss = this.analisisService.findAll(
						filterAnalisis, pagination);
				if (analisiss == null) {
					throw new Exception("No data Found.");
				}
				return analisiss;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterAnalisis
	 *            Analisis
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "analisis", required = false) Analisis filterAnalisis,
			HttpServletRequest request) {
		try {
			return analisisService
					.findAllCount(filterAnalisis != null ? filterAnalisis
							: new Analisis());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param analisis
	 *            Analisis
	 * @param response
	 *            HttpServletResponse
	 * @return Analisis
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Analisis edit(@RequestBody Analisis analisis, HttpServletResponse response) {
		try {
			Analisis analisisAux = this.analisisService.update(analisis);
			logger.info("Entity correctly inserted!");
			return analisisAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return Analisis
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Analisis add(@RequestBody Analisis analisis) {
		try {
			Analisis analisisAux = this.analisisService.add(analisis);
			logger.info("Entity correctly inserted!");
			return analisisAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addMuestra'.
	 * 
	 * @param analisisDetalle
	 *            AnalisisDetalle
	 * @param request
	 *            HttpServletRequest
	 * @return ActaActuacionAlta
	 */
	@RequestMapping(value = "/addMuestra", method = RequestMethod.POST)
	public @ResponseBody
	AnalisisDetalle addMuestra(@RequestBody AnalisisDetalle analisisDetalle,
			HttpServletRequest request) {
		try {
			AnalisisDetalle analisisDetalleAux = this.analisisService
					.registerMuestra(analisisDetalle);
			logger.info("Entity correctly inserted!");

			return analisisDetalleAux;

		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ancodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{ancodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String ancodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Analisis analisis = new Analisis();
			analisis.setAncodigo(ancodigo);
			this.analisisService.remove(analisis);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + ancodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param analisisIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> analisisIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Analisis> analisisList = new ArrayList<Analisis>();
		try {
			for (ArrayList<String> analisisId : analisisIds) {
				Iterator<String> iterator = analisisId.iterator();
				Analisis analisis = new Analisis();
				analisis.setAncodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				analisisList.add(analisis);
			}
			this.analisisService.removeMultiple(analisisList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAnalisisService'.
	 * 
	 * @return AnalisisService
	 */
	protected AnalisisService getAnalisisService() {
		return this.analisisService;
	}

	/**
	 * Method 'setAnalisisService'.
	 * 
	 * @param analisisService
	 *            AnalisisService
	 * @return
	 */
	public void setAnalisisService(AnalisisService analisisService) {
		this.analisisService = analisisService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
