package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.CaracterAlerta;
import com.ejie.y41a.service.AlertaRecibService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.AlertaRecib;

/**
 *  * AlertaRecibController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/alertarecib")

public class AlertaRecibController  {

	private static final Logger logger = LoggerFactory.getLogger(AlertaRecibController.class);

	@Autowired
	private AlertaRecibService alertaRecibService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("alertarecib", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  s5codigo String
	 * @return String
	 */
	@RequestMapping(value = "/{s5codigo}", method = RequestMethod.GET)
	public @ResponseBody AlertaRecib getById(@PathVariable String s5codigo) {
		try{
            AlertaRecib alertaRecib = new AlertaRecib();
			alertaRecib.setS5codigo(s5codigo);
            alertaRecib = this.alertaRecibService.find(alertaRecib);
            if (alertaRecib == null) {
                throw new Exception(s5codigo.toString());
            }
            return alertaRecib;
		}catch (Exception e){
		    throw new ResourceNotFoundException(s5codigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  s5codigo String
	 *@param	  alertaAlcodigo String
	 *@param	  caracterAlertaCrcodigo String
	 *@param	  s5codorganismo String
	 *@param	  s5feccomunicacion Date
	 *@param	  s5fecfinalizacion Date
	 *@param	  s5cantidadactuaciones Integer
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "s5codigo", required = false) String s5codigo,
	@RequestParam(value = "alertaAlcodigo", required = false) String alertaAlcodigo,
	@RequestParam(value = "caracterAlertaCrcodigo", required = false) String caracterAlertaCrcodigo,
	@RequestParam(value = "s5codorganismo", required = false) String s5codorganismo,
	@RequestParam(value = "s5feccomunicacion", required = false) Date s5feccomunicacion,
	@RequestParam(value = "s5fecfinalizacion", required = false) Date s5fecfinalizacion,
	@RequestParam(value = "s5cantidadactuaciones", required = false) Integer s5cantidadactuaciones,
			HttpServletRequest request) {
			try{
				AlertaRecib filterAlertaRecib = new AlertaRecib(s5codigo, s5codorganismo, s5feccomunicacion, s5fecfinalizacion, s5cantidadactuaciones, new Alerta(alertaAlcodigo, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null), new CaracterAlerta(caracterAlertaCrcodigo, null, null, null, null, null, null, null, null));
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<AlertaRecib> alertaRecibs =  this.alertaRecibService.findAll(filterAlertaRecib, pagination);

     			    if (alertaRecibs == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterAlertaRecib, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(alertaRecibs);
				    return data;
				}else{
				    List<AlertaRecib> alertaRecibs =  this.alertaRecibService.findAll(filterAlertaRecib, pagination);
					if (alertaRecibs == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return alertaRecibs;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterAlertaRecib AlertaRecib 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "alertaRecib", required = false) AlertaRecib  filterAlertaRecib, HttpServletRequest request) {
	    try {
			return alertaRecibService
					.findAllCount(filterAlertaRecib != null ? filterAlertaRecib
							: new AlertaRecib ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param alertaRecib AlertaRecib 
	 * @param response HttpServletResponse
	 * @return AlertaRecib
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody AlertaRecib edit(@RequestBody AlertaRecib alertaRecib, HttpServletResponse response) {		
		try {
            AlertaRecib alertaRecibAux  = this.alertaRecibService.update(alertaRecib);
			logger.info("Entity correctly inserted!");
            return alertaRecibAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param alertaRecib AlertaRecib 
	 * @return AlertaRecib
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody AlertaRecib add(@RequestBody AlertaRecib alertaRecib) {		
        try {
            AlertaRecib alertaRecibAux = this.alertaRecibService.add(alertaRecib);
            logger.info("Entity correctly inserted!");
        	return alertaRecibAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  s5codigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{s5codigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String s5codigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            AlertaRecib alertaRecib = new AlertaRecib();
            alertaRecib.setS5codigo(s5codigo);
            this.alertaRecibService.remove(alertaRecib);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  s5codigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  alertaRecibIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> alertaRecibIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<AlertaRecib> alertaRecibList = new ArrayList<AlertaRecib>();
        try{		    
            for (ArrayList<String> alertaRecibId:alertaRecibIds) {
			    Iterator<String> iterator = alertaRecibId.iterator();
				    AlertaRecib alertaRecib = new AlertaRecib();
			        alertaRecib.setS5codigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    alertaRecibList.add(alertaRecib);
		    }
            this.alertaRecibService.removeMultiple(alertaRecibList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAlertaRecibService'.
	 *
	 * @return AlertaRecibService
	 */
	protected AlertaRecibService getAlertaRecibService() {
		return this.alertaRecibService;
	}

	/**
	 * Method 'setAlertaRecibService'.
	 *
	 * @param alertaRecibService  AlertaRecibService
	 * @return
	 */
	public void setAlertaRecibService(AlertaRecibService alertaRecibService) {
		this.alertaRecibService = alertaRecibService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
