package com.ejie.y41a.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.AlertaDetalle;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Comaut;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Pais;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.TipOrigenProd;
import com.ejie.y41a.service.AlertaService;

/**
 * * AlertaController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/alerta")
public class AlertaController {

	private static final Logger logger = LoggerFactory
			.getLogger(AlertaController.class);

	@Autowired
	private AlertaService alertaService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("alerta", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param alcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{alcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Alerta getById(@PathVariable String alcodigo) {
		try {
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(alcodigo);
			alerta = this.alertaService.find(alerta);
			if (alerta == null) {
				throw new Exception(alcodigo.toString());
			}
			return alerta;
		} catch (Exception e) {
			throw new ResourceNotFoundException(alcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param alcodigo
	 *            String
	 * @param comautCacodigo
	 *            String
	 * @param productoPscodigo
	 *            String
	 * @param tipOrigenProdTopcodigo
	 *            String
	 * @param paisPacodigo
	 *            String
	 * @param establecimientoEscodigo
	 *            String
	 * @param alcoor
	 *            String
	 * @param alnran
	 *            Long
	 * @param alnror
	 *            String
	 * @param alfeen
	 *            Date
	 * @param alfeplrr
	 *            Date
	 * @param alnoprse
	 *            String
	 * @param alnrlops
	 *            String
	 * @param alnomaps
	 *            String
	 * @param alnomops
	 *            String
	 * @param alfedumi
	 *            Date
	 * @param altein
	 *            String
	 * @param alferrin
	 *            Date
	 * @param alinre
	 *            String
	 * @param alfecoor
	 *            Date
	 * @param alcotmo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "alcodigo", required = false) String alcodigo,
			@RequestParam(value = "comautCacodigo", required = false) String comautCacodigo,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo,
			@RequestParam(value = "tipOrigenProdTopcodigo", required = false) String tipOrigenProdTopcodigo,
			@RequestParam(value = "paisPacodigo", required = false) String paisPacodigo,
			@RequestParam(value = "establecimientoEscodigo", required = false) String establecimientoEscodigo,
			@RequestParam(value = "alcoor", required = false) String alcoor,
			@RequestParam(value = "alnran", required = false) Long alnran,
			@RequestParam(value = "alnror", required = false) String alnror,
			@RequestParam(value = "alfeen", required = false) Date alfeen,
			@RequestParam(value = "alfeplrr", required = false) Date alfeplrr,
			@RequestParam(value = "alnoprse", required = false) String alnoprse,
			@RequestParam(value = "alnrlops", required = false) String alnrlops,
			@RequestParam(value = "alnomaps", required = false) String alnomaps,
			@RequestParam(value = "alnomops", required = false) String alnomops,
			@RequestParam(value = "alfedumi", required = false) Date alfedumi,
			@RequestParam(value = "altein", required = false) String altein,
			@RequestParam(value = "alferrin", required = false) Date alferrin,
			@RequestParam(value = "alinre", required = false) String alinre,
			@RequestParam(value = "alfecoor", required = false) Date alfecoor,
			@RequestParam(value = "alcotmo", required = false) String alcotmo,
			HttpServletRequest request) {
		try {
			Alerta filterAlerta = new Alerta(alcodigo, alcoor, alnran, alnror,
					alfeen, alfeplrr, alnoprse, alnrlops, alnomaps, alnomops,
					alfedumi, altein, alferrin, alinre, alfecoor, alcotmo,
					new Comaut(comautCacodigo, null, null, null), new Producto(
							productoPscodigo, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null),
					new TipOrigenProd(tipOrigenProdTopcodigo, null, null),
					new Pais(paisPacodigo, null, null, null, null, null),
					new Establecimiento(establecimientoEscodigo, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Alerta> alertas = this.alertaService.findAll(filterAlerta,
						pagination);

				if (alertas == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterAlerta, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(alertas);
				return data;
			} else {
				List<Alerta> alertas = this.alertaService.findAll(filterAlerta,
						pagination);
				if (alertas == null) {
					throw new Exception("No data Found.");
				}
				return alertas;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterAlerta
	 *            Alerta
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "alerta", required = false) Alerta filterAlerta,
			HttpServletRequest request) {
		try {
			return alertaService
					.findAllCount(filterAlerta != null ? filterAlerta
							: new Alerta());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/buscaralerta", method = RequestMethod.GET)
	public @ResponseBody
	AlertaDetalle getByIdCamapaniaAlerta(
			@RequestParam(value = "cmcodigo", required = true) String cmcodigo,
			HttpServletRequest request) {
		try {
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(cmcodigo);

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);
			alerta.setAlcoor(censoMonitor.getOrganismo().getCodOrg());

			AlertaDetalle alertaDetalle = new AlertaDetalle();
			alertaDetalle = this.alertaService.findAlerta(alerta);
			if (alertaDetalle == null) {
				throw new Exception(cmcodigo.toString());
			}
			return alertaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cmcodigo.toString());
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param response
	 *            HttpServletResponse
	 * @return Alerta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Alerta edit(@RequestBody Alerta alerta, HttpServletResponse response) {
		try {
			Alerta alertaAux = this.alertaService.update(alerta);
			logger.info("Entity correctly inserted!");
			return alertaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Alerta add(@RequestBody Alerta alerta) {
		try {
			Alerta alertaAux = this.alertaService.add(alerta);
			logger.info("Entity correctly inserted!");
			return alertaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param alcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{alcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String alcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Alerta alerta = new Alerta();
			alerta.setAlcodigo(alcodigo);
			this.alertaService.remove(alerta);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + alcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param alertaIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> alertaIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Alerta> alertaList = new ArrayList<Alerta>();
		try {
			for (ArrayList<String> alertaId : alertaIds) {
				Iterator<String> iterator = alertaId.iterator();
				Alerta alerta = new Alerta();
				alerta.setAlcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				alertaList.add(alerta);
			}
			this.alertaService.removeMultiple(alertaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAlertaService'.
	 * 
	 * @return AlertaService
	 */
	protected AlertaService getAlertaService() {
		return this.alertaService;
	}

	/**
	 * Method 'setAlertaService'.
	 * 
	 * @param alertaService
	 *            AlertaService
	 * @return
	 */
	public void setAlertaService(AlertaService alertaService) {
		this.alertaService = alertaService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
