package com.ejie.y41a.control;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Acta;
import com.ejie.y41a.model.ActaActuacionAlta;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.ActuacionBusqueda;
import com.ejie.y41a.model.ActuacionDetalle;
import com.ejie.y41a.model.AlertaRecib;
import com.ejie.y41a.model.CampahnaActuacionBusqueda;
import com.ejie.y41a.model.CampahnaRecib;
import com.ejie.y41a.model.DenunciaRecib;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.TipActuacion;
import com.ejie.y41a.model.TipProtocolo;
import com.ejie.y41a.model.TipmotActuacion;
import com.ejie.y41a.model.VisitaDetalle;
import com.ejie.y41a.service.ActuacionService;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * ActuacionController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/actuacion")
public class ActuacionController {

	private static final Logger logger = LoggerFactory
			.getLogger(ActuacionController.class);

	@Autowired()
	private ActuacionService actuacionService;
	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "actMaintCampanias", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("actuacion", "model", model);
	}

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "actuacionModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("actuacionModal", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "actMaintBusqueda", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaActuacion(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("busqueda_actuacion", "model", model);
	}

	/**
	 * Method 'getCreateFormNuevaActuacion'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "nuevaActuacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormNuevaActuacion(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("nuevaActuacion", "model", model);
	}

	/**
	 * Method 'getCreateFormInspeccionOficio'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "inspeccionOficio", method = RequestMethod.GET)
	public ModelAndView getCreateFormInspeccionOficio(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("inspeccionOficio", "model", model);
	}

	/**
	 * Method 'getCreateFormVisita'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "visitaTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormVisita(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("visitaTab", "model", model);
	}

	/**
	 * Method 'getCreateFormActuacion'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "actuacionTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormActuacion(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("actuacionTab", "model", model);
	}

	/**
	 * Method 'getCreateFormConstatacion'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "constatacionTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormConstatacion(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("constatacionTab", "model", model);
	}

	/**
	 * Method 'getCreateFormProtocolo'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "protocoloTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormProtocolo(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("protocoloTab", "model", model);
	}

	/**
	 * Method 'getCreateFormMuestra'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "muestraTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormMuestra(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("muestraTab", "model", model);
	}

	/**
	 * Method 'getCreateFormDocumentos'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "documentosTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormDocumentos(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("documentosTab", "model", model);
	}

	/**
	 * Method 'getCreateFormImpresionCartas'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "impresionCartasActuaciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormImpresionCartas(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("impresionCartasActuaciones", "model", model);
	}

	/**
	 * Method 'getBusqueda'.
	 * 
	 * @param CodigoRecivido
	 *            String
	 * @param Tipo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * 
	 */
	@RequestMapping(value = "/buscarActuacion", method = RequestMethod.GET)
	public @ResponseBody()
	Object getBusqueda(
			@RequestParam(value = "CodigoRecivido", required = true) String CodigoRecivido,
			@RequestParam(value = "Tipo", required = true) String Tipo,
			HttpServletRequest request) {
		try {
			CampahnaActuacionBusqueda campahnaActuacionBusqueda = new CampahnaActuacionBusqueda();

			if (Tipo.equals(Y41aConstantes.TIPO_CAMPAHNA)) {
				campahnaActuacionBusqueda.setAtcocm(CodigoRecivido);
			} else if (Tipo.equals(Y41aConstantes.TIPO_DENUNCIA)) {
				campahnaActuacionBusqueda.setAtcohd(CodigoRecivido);
			} else if (Tipo.equals(Y41aConstantes.TIPO_ALERTA)) {
				campahnaActuacionBusqueda.setAtcoal(CodigoRecivido);
			}

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<CampahnaActuacionBusqueda> campahnaActuacionBusquedaAux = this.actuacionService
						.findAllCampahnaActuacion(campahnaActuacionBusqueda,
								pagination);

				if (campahnaActuacionBusquedaAux == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountActuacion(campahnaActuacionBusqueda,
						request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(campahnaActuacionBusquedaAux);
				return data;
			} else {
				List<CampahnaActuacionBusqueda> campahnaActuacionBusquedaAux = this.actuacionService
						.findAllCampahnaActuacion(campahnaActuacionBusqueda,
								pagination);

				if (campahnaActuacionBusquedaAux == null) {
					throw new Exception(CodigoRecivido.toString());
				}

				return campahnaActuacionBusquedaAux;
			}

		} catch (Exception e) {
			throw new ResourceNotFoundException(CodigoRecivido.toString());
		}
	}

	/**
	 * Method 'getAllCountActuacion'.
	 * 
	 * @param campahnaActuacionBusqueda
	 *            CampahnaActuacionBusqueda
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCountActuacion(
			@RequestParam(value = "campahnaActuacionBusqueda", required = false) CampahnaActuacionBusqueda campahnaActuacionBusqueda,
			HttpServletRequest request) {
		try {
			return this.actuacionService
					.findAllCampahnaActuacionCount(campahnaActuacionBusqueda != null ? campahnaActuacionBusqueda
							: new CampahnaActuacionBusqueda());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param atcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "getById/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Actuacion getById(@PathVariable() String atcodigo) {
		try {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);
			actuacion = this.actuacionService.find(actuacion);
			if (actuacion == null) {
				throw new Exception(atcodigo.toString());
			}
			return actuacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(atcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param tipProtocoloTpcodigo
	 *            String
	 * @param actaAccodigo
	 *            String
	 * @param campahnaRecibS4codigo
	 *            String
	 * @param establecimientoEscodigo
	 *            String
	 * @param productoPscodigo
	 *            String
	 * @param denunciaRecibS6codigo
	 *            String
	 * @param alertaRecibS5codigo
	 *            String
	 * @param tipActuacionTtacodigo
	 *            String
	 * @param tipmotActuacionTmacodigo
	 *            String
	 * @param atnror
	 *            BigDecimal
	 * @param atcoav
	 *            String
	 * @param atcose
	 *            String
	 * @param atnoprse
	 *            String
	 * @param atnomaps
	 *            String
	 * @param atnomops
	 *            String
	 * @param atnrlops
	 *            String
	 * @param atfedumi
	 *            Date
	 * @param atinprse
	 *            String
	 * @param atcaunep
	 *            BigDecimal
	 * @param atteinfo
	 *            String
	 * @param atcoat
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "getAll", method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "atcodigo", required = false) String atcodigo,
			@RequestParam(value = "tipProtocoloTpcodigo", required = false) String tipProtocoloTpcodigo,
			@RequestParam(value = "actaAccodigo", required = false) String actaAccodigo,
			@RequestParam(value = "campahnaRecibS4codigo", required = false) String campahnaRecibS4codigo,
			@RequestParam(value = "establecimientoEscodigo", required = false) String establecimientoEscodigo,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo,
			@RequestParam(value = "denunciaRecibS6codigo", required = false) String denunciaRecibS6codigo,
			@RequestParam(value = "alertaRecibS5codigo", required = false) String alertaRecibS5codigo,
			@RequestParam(value = "tipActuacionTtacodigo", required = false) String tipActuacionTtacodigo,
			@RequestParam(value = "tipmotActuacionTmacodigo", required = false) String tipmotActuacionTmacodigo,
			@RequestParam(value = "atnror", required = false) BigDecimal atnror,
			@RequestParam(value = "atcoav", required = false) String atcoav,
			@RequestParam(value = "atcose", required = false) String atcose,
			@RequestParam(value = "atnoprse", required = false) String atnoprse,
			@RequestParam(value = "atnomaps", required = false) String atnomaps,
			@RequestParam(value = "atnomops", required = false) String atnomops,
			@RequestParam(value = "atnrlops", required = false) String atnrlops,
			@RequestParam(value = "atfedumi", required = false) Date atfedumi,
			@RequestParam(value = "atinprse", required = false) String atinprse,
			@RequestParam(value = "atcaunep", required = false) BigDecimal atcaunep,
			@RequestParam(value = "atteinfo", required = false) String atteinfo,
			@RequestParam(value = "atcoat", required = false) String atcoat,
			HttpServletRequest request) {
		try {
			Actuacion filterActuacion = new Actuacion(atcodigo, atnror, atcoav,
					atcose, atnoprse, atnomaps, atnomops, atnrlops, atfedumi,
					atinprse, atcaunep, atteinfo, atcoat,
					new TipProtocolo(tipProtocoloTpcodigo, null, null, null,
							null, null), new Acta(actaAccodigo, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null), new CampahnaRecib(
							campahnaRecibS4codigo, null, null, null, null,
							null, null), new Establecimiento(
							establecimientoEscodigo, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null),
					new Producto(productoPscodigo, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null),
					new DenunciaRecib(denunciaRecibS6codigo, null, null, null,
							null, null, null), new AlertaRecib(
							alertaRecibS5codigo, null, null, null, null, null,
							null, null), new TipActuacion(
							tipActuacionTtacodigo, null, null),
					new TipmotActuacion(tipmotActuacionTmacodigo, null, null));

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Actuacion> actuacions = this.actuacionService.findAll(
						filterActuacion, pagination);

				if (actuacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterActuacion, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(actuacions);
				return data;
			} else {
				List<Actuacion> actuacions = this.actuacionService.findAll(
						filterActuacion, pagination);
				if (actuacions == null) {
					throw new Exception("No data Found.");
				}
				return actuacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * 
	 * @param y41aActuacionesCodA
	 *            String
	 * @param y41aActuacionesCodB
	 *            String
	 * @param y41aActuacionesCodC
	 *            String
	 * @param y41aActuacionFechaDesde
	 *            String
	 * @param y41aActuacionFechaHasta
	 *            String
	 * @param y41aActuacionComboInspectores
	 *            String
	 * @param y41aActuacionVisitaSectorId
	 *            String
	 * @param y41aActuacionEstablecimientoVisit
	 *            String
	 * @param y41aActuacionEstablecimientoVisitCif
	 *            String
	 * @param y41aActuacionesEstablecimientoResp
	 *            String
	 * @param y41aActuacionesEstablecimientoRespCif
	 *            String
	 * @param y41aActuacionComboTipo
	 *            String
	 * @param y41aActuacionComboMotivo
	 *            String
	 * @param y41aActuacionActuacionSectorId
	 *            String
	 * @param y41aActuacionProductoServicioId
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return object
	 */
	@RequestMapping(value = "getActuacionesAll", method = RequestMethod.GET)
	public @ResponseBody()
	Object getActuacionesAll(
			@RequestParam(value = "y41aActuacionesCodA_", required = false) String y41aActuacionesCodA,
			@RequestParam(value = "y41aActuacionesCodB_", required = false) String y41aActuacionesCodB,
			@RequestParam(value = "y41aActuacionesCodC_", required = false) String y41aActuacionesCodC,

			@RequestParam(value = "y41aActuacionFechaDesde_", required = false) String y41aActuacionFechaDesde,
			@RequestParam(value = "y41aActuacionFechaHasta_", required = false) String y41aActuacionFechaHasta,

			@RequestParam(value = "y41aActuacionComboInspectores_", required = false) String y41aActuacionComboInspectores,

			@RequestParam(value = "y41aActuacionVisitaSectorId_", required = false) String y41aActuacionVisitaSectorId,
			@RequestParam(value = "y41aActuacionEstablecimientoVisit_", required = false) String y41aActuacionEstablecimientoVisit,
			@RequestParam(value = "y41aActuacionEstablecimientoVisitCif_", required = false) String y41aActuacionEstablecimientoVisitCif,
			@RequestParam(value = "y41aActuacionesEstablecimientoResp_", required = false) String y41aActuacionesEstablecimientoResp,
			@RequestParam(value = "y41aActuacionesEstablecimientoRespCif_", required = false) String y41aActuacionesEstablecimientoRespCif,
			@RequestParam(value = "y41aActuacionComboTipo_", required = false) String y41aActuacionComboTipo,
			@RequestParam(value = "y41aActuacionComboMotivo_", required = false) String y41aActuacionComboMotivo,

			@RequestParam(value = "y41aActuacionActuacionSectorId_", required = false) String y41aActuacionActuacionSectorId,
			@RequestParam(value = "y41aActuacionProductoServicioId_", required = false) String y41aActuacionProductoServicioId,
			HttpServletRequest request) {

		// parseo de fechas
		Locale locale = LocaleContextHolder.getLocale();

		try {
			ActuacionBusqueda filterActuacion = new ActuacionBusqueda();

			filterActuacion.setAccoor(Y41aUtils
					.normalizarNulo(y41aActuacionesCodA));
			filterActuacion.setAcnror(Y41aUtils
					.normalizarNulo(y41aActuacionesCodB));
			filterActuacion.setAcnran(Y41aUtils
					.normalizarBigDecimal(y41aActuacionesCodC));

			if (y41aActuacionComboInspectores != null
					&& !y41aActuacionComboInspectores.equals("")) {
				filterActuacion.setInspector(y41aActuacionComboInspectores);
			}

			filterActuacion.setEsnombreVisita(Y41aUtils
					.normalizarNulo(y41aActuacionEstablecimientoVisit));
			filterActuacion.setEsnifVisita(Y41aUtils
					.normalizarNulo(y41aActuacionEstablecimientoVisitCif));
			filterActuacion.setEsnombreActuacion(Y41aUtils
					.normalizarNulo(y41aActuacionesEstablecimientoResp));
			filterActuacion.setEsnifActuacion(Y41aUtils
					.normalizarNulo(y41aActuacionesEstablecimientoRespCif));

			Date dtfechaDesde = Y41aUtils.parseDate(y41aActuacionFechaDesde,
					locale);
			Date dtfechaHasta = Y41aUtils.parseDate(y41aActuacionFechaHasta,
					locale);
			filterActuacion.setAcfeleDesde(dtfechaDesde);
			filterActuacion.setAcfeleHasta(dtfechaHasta);

			if (y41aActuacionComboTipo != null
					&& !y41aActuacionComboTipo.equals("")) {
				filterActuacion.setTtacodigo(y41aActuacionComboTipo);
			}
			if (y41aActuacionComboMotivo != null
					&& !y41aActuacionComboMotivo.equals("")) {
				filterActuacion.setTmacodigo(y41aActuacionComboMotivo);
			}
			if (y41aActuacionVisitaSectorId != null
					&& !y41aActuacionVisitaSectorId.equals("")) {
				filterActuacion.setSecodigoVisita(y41aActuacionVisitaSectorId);
			}
			if (y41aActuacionActuacionSectorId != null
					&& !y41aActuacionActuacionSectorId.equals("")) {
				filterActuacion
						.setSecodigoActuacion(y41aActuacionActuacionSectorId);
			}
			if (y41aActuacionProductoServicioId != null
					&& !y41aActuacionProductoServicioId.equals("")) {
				filterActuacion
						.setPscodigoActuacion(y41aActuacionProductoServicioId);
			}

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<ActuacionBusqueda> actuacions = this.actuacionService
						.findAllLikeActuacion(filterActuacion, pagination,
								false);

				if (actuacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.actuacionService.findAllLikeActuacionCount(
						filterActuacion, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(actuacions);
				return data;
			} else {
				List<ActuacionBusqueda> actuacions = this.actuacionService
						.findAllLikeActuacion(filterActuacion, null, false);
				if (actuacions == null) {
					throw new Exception("No data Found.");
				}
				return actuacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterActuacion
	 *            Actuacion
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "actuacion", required = false) Actuacion filterActuacion,
			HttpServletRequest request) {
		try {
			return actuacionService
					.findAllCount(filterActuacion != null ? filterActuacion
							: new Actuacion());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getActaActuacion'.
	 * 
	 * @param atcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/buscarActaActuacion", method = RequestMethod.GET)
	public @ResponseBody
	ActaActuacionAlta getActaActuacion(
			@RequestParam(value = "atcodigo", required = false) String atcodigo) {
		try {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			ActaActuacionAlta actaActuacionAlta = this.actuacionService
					.findActaActuacion(actuacion);
			if (actaActuacionAlta == null) {
				throw new Exception(atcodigo.toString());
			}
			return actaActuacionAlta;
		} catch (Exception e) {
			throw new ResourceNotFoundException(atcodigo.toString());
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param response
	 *            HttpServletResponse
	 * @return Actuacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Actuacion edit(@RequestBody Actuacion actuacion,
			HttpServletResponse response) {
		try {
			Actuacion actuacionAux = this.actuacionService.update(actuacion);
			logger.info("Entity correctly inserted!");
			return actuacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Actuacion add(@RequestBody Actuacion actuacion) {
		try {
			Actuacion actuacionAux = this.actuacionService.add(actuacion);
			logger.info("Entity correctly inserted!");
			return actuacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addActuacion'.
	 * 
	 * @param actaActuacionAlta
	 *            ActaActuacionAlta
	 * @param request
	 *            HttpServletRequest
	 * @return ActaActuacionAlta
	 */
	@RequestMapping(value = "/altaActaActuacion", method = RequestMethod.POST)
	public @ResponseBody
	ActaActuacionAlta addActuacion(
			@RequestBody ActaActuacionAlta actaActuacionAlta,
			HttpServletRequest request) {
		try {

			ActaActuacionAlta actaActuacionAltaAux = this.actuacionService
					.addActaActuacion(actaActuacionAlta);
			logger.info("Entity correctly inserted!");

			return actaActuacionAltaAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addNuevaActuacion'.
	 * 
	 * @param actaActuacionAlta
	 *            ActaActuacionAlta
	 * @param request
	 *            HttpServletRequest
	 * @return ActaActuacionAlta
	 */
	@RequestMapping(value = "/altaNuevaActuacion", method = RequestMethod.POST)
	public @ResponseBody
	ActaActuacionAlta addNuevaActuacion(
			@RequestBody ActaActuacionAlta actaActuacionAlta,
			HttpServletRequest request) {
		try {

			ActaActuacionAlta actaActuacionAltaAux = this.actuacionService
					.addActuacion(actaActuacionAlta);
			logger.info("Entity correctly inserted!");

			return actaActuacionAltaAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'updateVisita'.
	 * 
	 * @param visitaDetalle
	 *            VisitaDetalle
	 * @param request
	 *            HttpServletRequest
	 * @return ActaActuacionAlta
	 */
	@RequestMapping(value = "/updateVisitaActuacion", method = RequestMethod.PUT)
	public @ResponseBody
	VisitaDetalle updateVisita(@RequestBody VisitaDetalle visitaDetalle,
			HttpServletRequest request) {
		try {

			VisitaDetalle visitaDetalleAux = this.actuacionService
					.updateActa(visitaDetalle);
			logger.info("Entity correctly inserted!");

			return visitaDetalleAux;

		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'updateActuacion'.
	 * 
	 * @param actuacionDetalle
	 *            ActuacionDetalle
	 * @param request
	 *            HttpServletRequest
	 * @return ActaActuacionAlta
	 */
	@RequestMapping(value = "/updateActaActuacion", method = RequestMethod.PUT)
	public @ResponseBody
	ActuacionDetalle updateActuacion(
			@RequestBody ActuacionDetalle actuacionDetalle,
			HttpServletRequest request) {
		try {

			ActuacionDetalle actuacionDetalleAux = this.actuacionService
					.updateActuacion(actuacionDetalle);
			logger.info("Entity correctly inserted!");

			return actuacionDetalleAux;

		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{atcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String atcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);
			this.actuacionService.remove(actuacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + atcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param actuacionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> actuacionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Actuacion> actuacionList = new ArrayList<Actuacion>();
		try {
			for (ArrayList<String> actuacionId : actuacionIds) {
				Iterator<String> iterator = actuacionId.iterator();
				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				actuacionList.add(actuacion);
			}
			this.actuacionService.removeMultiple(actuacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getActuacionService'.
	 * 
	 * @return ActuacionService
	 */
	protected ActuacionService getActuacionService() {
		return this.actuacionService;
	}

	/**
	 * Method 'setActuacionService'.
	 * 
	 * @param actuacionService
	 *            ActuacionService
	 * @return
	 */
	public void setActuacionService(ActuacionService actuacionService) {
		this.actuacionService = actuacionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
