package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.ActividadService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Actividad;

/**
 *  * ActividadController generated by UDA, 01-feb-2012 17:10:42.
 *  
 */
 
@Controller
@RequestMapping (value = "/actividad")

public class ActividadController  {

	private static final Logger logger = LoggerFactory.getLogger(ActividadController.class);

	@Autowired
	private ActividadService actividadService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("actividad", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  avcodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{avcodigo}", method = RequestMethod.GET)
	public @ResponseBody Actividad getById(@PathVariable String avcodigo) {
		try{
            Actividad actividad = new Actividad();
			actividad.setAvcodigo(avcodigo);
            actividad = this.actividadService.find(actividad);
            if (actividad == null) {
                throw new Exception(avcodigo.toString());
            }
            return actividad;
		}catch (Exception e){
		    throw new ResourceNotFoundException(avcodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  avcodigo String
	 *@param	  avnombre String
	 *@param	  avnoco String
	 *@param	  avtede String
	 *@param	  avcose String
	 *@param	  avnombree String
	 *@param	  avnombrei String
	 *@param	  avnombref String
	 *@param	  avnocoe String
	 *@param	  avnocoi String
	 *@param	  avnocof String
	 *@param	  avtedee String
	 *@param	  avtedei String
	 *@param	  avtedef String
	 *@param	  avnombrea String
	 *@param	  avnocoa String
	 *@param	  avtedea String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "avcodigo", required = false) String avcodigo,
	@RequestParam(value = "avnombre", required = false) String avnombre,
	@RequestParam(value = "avnoco", required = false) String avnoco,
	@RequestParam(value = "avtede", required = false) String avtede,
	@RequestParam(value = "avcose", required = false) String avcose,
	@RequestParam(value = "avnombree", required = false) String avnombree,
	@RequestParam(value = "avnombrei", required = false) String avnombrei,
	@RequestParam(value = "avnombref", required = false) String avnombref,
	@RequestParam(value = "avnocoe", required = false) String avnocoe,
	@RequestParam(value = "avnocoi", required = false) String avnocoi,
	@RequestParam(value = "avnocof", required = false) String avnocof,
	@RequestParam(value = "avtedee", required = false) String avtedee,
	@RequestParam(value = "avtedei", required = false) String avtedei,
	@RequestParam(value = "avtedef", required = false) String avtedef,
	@RequestParam(value = "avnombrea", required = false) String avnombrea,
	@RequestParam(value = "avnocoa", required = false) String avnocoa,
	@RequestParam(value = "avtedea", required = false) String avtedea,
			HttpServletRequest request) {
			try{
				Actividad filterActividad = new Actividad(avcodigo, avnombre, avnoco, avtede, avcose, avnombree, avnombrei, avnombref, avnocoe, avnocoi, avnocof, avtedee, avtedei, avtedef, avnombrea, avnocoa, avtedea);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<Actividad> actividads =  this.actividadService.findAll(filterActividad, pagination);

     			    if (actividads == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterActividad, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(actividads);
				    return data;
				}else{
				    List<Actividad> actividads =  this.actividadService.findAll(filterActividad, pagination);
					if (actividads == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return actividads;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterActividad Actividad 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "actividad", required = false) Actividad  filterActividad, HttpServletRequest request) {
	    try {
			return actividadService
					.findAllCount(filterActividad != null ? filterActividad
							: new Actividad ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param actividad Actividad 
	 * @param response HttpServletResponse
	 * @return Actividad
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Actividad edit(@RequestBody Actividad actividad, HttpServletResponse response) {		
		try {
            Actividad actividadAux  = this.actividadService.update(actividad);
			logger.info("Entity correctly inserted!");
            return actividadAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param actividad Actividad 
	 * @return Actividad
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Actividad add(@RequestBody Actividad actividad) {		
        try {
            Actividad actividadAux = this.actividadService.add(actividad);
            logger.info("Entity correctly inserted!");
        	return actividadAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  avcodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{avcodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String avcodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            Actividad actividad = new Actividad();
            actividad.setAvcodigo(avcodigo);
            this.actividadService.remove(actividad);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  avcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  actividadIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> actividadIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<Actividad> actividadList = new ArrayList<Actividad>();
        try{		    
            for (ArrayList<String> actividadId:actividadIds) {
			    Iterator<String> iterator = actividadId.iterator();
				    Actividad actividad = new Actividad();
			        actividad.setAvcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    actividadList.add(actividad);
		    }
            this.actividadService.removeMultiple(actividadList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getActividadService'.
	 *
	 * @return ActividadService
	 */
	protected ActividadService getActividadService() {
		return this.actividadService;
	}

	/**
	 * Method 'setActividadService'.
	 *
	 * @param actividadService  ActividadService
	 * @return
	 */
	public void setActividadService(ActividadService actividadService) {
		this.actividadService = actividadService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
