package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.TipReqNormativo;
import com.ejie.y41a.service.ActaInfraccionService;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
//import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.ActaInfraccion;
import com.ejie.y41a.model.ActaInfraccionBusqueda;

//import com.ejie.y41a.model.Actuacion;
//import com.ejie.y41a.model.Establecimiento;
//import com.ejie.y41a.model.TipReqNormativo;

/**
 * * ActaInfraccionController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/actainfraccion")
public class ActaInfraccionController {

	private static final Logger logger = LoggerFactory
			.getLogger(ActaInfraccionController.class);

	@Autowired
	private ActaInfraccionService actaInfraccionService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("actainfraccion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param aicodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{aicodigo}", method = RequestMethod.GET)
	public @ResponseBody
	ActaInfraccion getById(@PathVariable String aicodigo) {
		try {
			ActaInfraccion actaInfraccion = new ActaInfraccion();
			actaInfraccion.setAicodigo(aicodigo);
			actaInfraccion = this.actaInfraccionService.find(actaInfraccion);
			if (actaInfraccion == null) {
				throw new Exception(aicodigo.toString());
			}
			return actaInfraccion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(aicodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param aicodigo
	 *            String
	 * @param actuacionAtcodigo
	 *            String
	 * @param tipReqNormativoTticodigo
	 *            String
	 * @param aiinexii
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "aicodigo", required = false) String aicodigo,
			@RequestParam(value = "actuacionAtcodigo", required = false) String actuacionAtcodigo,
			@RequestParam(value = "tipReqNormativoTticodigo", required = false) String tipReqNormativoTticodigo,
			@RequestParam(value = "aiinexii", required = false) String aiinexii,
			HttpServletRequest request) {
		try {
			ActaInfraccion filterActaInfraccion = new ActaInfraccion(aicodigo,
					aiinexii, new Actuacion(actuacionAtcodigo, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null),
					new TipReqNormativo(tipReqNormativoTticodigo, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ActaInfraccion> actaInfraccions = this.actaInfraccionService
						.findAll(filterActaInfraccion, pagination);

				if (actaInfraccions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterActaInfraccion, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(actaInfraccions);
				return data;
			} else {
				List<ActaInfraccion> actaInfraccions = this.actaInfraccionService
						.findAll(filterActaInfraccion, pagination);
				if (actaInfraccions == null) {
					throw new Exception("No data Found.");
				}
				return actaInfraccions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllConstatacion'.
	 * 
	 * @param aicodigo
	 *            String
	 * @param actuacionAtcodigo
	 *            String
	 * @param tipReqNormativoTticodigo
	 *            String
	 * @param aiinexii
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllConstatacion", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllActaInfraccion(
			@RequestParam(value = "aicodigo", required = false) String aicodigo,
			@RequestParam(value = "actuacionAtcodigo", required = false) String actuacionAtcodigo,
			@RequestParam(value = "tipReqNormativoTticodigo", required = false) String tipReqNormativoTticodigo,
			@RequestParam(value = "aiinexii", required = false) String aiinexii,
			HttpServletRequest request) {
		try {

			ActaInfraccion filterActaInfraccion = new ActaInfraccion(aicodigo,
					aiinexii, new Actuacion(actuacionAtcodigo, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null),
					new TipReqNormativo(tipReqNormativoTticodigo, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ActaInfraccionBusqueda> actaInfraccions = this.actaInfraccionService
						.findAllConstatacion(filterActaInfraccion, pagination);

				if (actaInfraccions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterActaInfraccion, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(actaInfraccions);
				return data;
			} else {
				List<ActaInfraccionBusqueda> actaInfraccions = this.actaInfraccionService
						.findAllConstatacion(filterActaInfraccion, pagination);
				if (actaInfraccions == null) {
					throw new Exception("No data Found.");
				}
				return actaInfraccions;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterActaInfraccion
	 *            ActaInfraccion
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "actaInfraccion", required = false) ActaInfraccion filterActaInfraccion,
			HttpServletRequest request) {
		try {
			return actaInfraccionService
					.findAllCount(filterActaInfraccion != null ? filterActaInfraccion
							: new ActaInfraccion());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @param response
	 *            HttpServletResponse
	 * @return ActaInfraccion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	ActaInfraccion edit(@RequestBody ActaInfraccion actaInfraccion,
			HttpServletResponse response) {
		try {
			ActaInfraccion actaInfraccionAux = this.actaInfraccionService
					.update(actaInfraccion);
			logger.info("Entity correctly inserted!");
			return actaInfraccionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editConsMultiple'.
	 * 
	 * * @param atcodigo String
	 * 
	 * @param actaInfraccionArray
	 *            ArrayList<String>
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/editConsMultiple", method = RequestMethod.PUT)
	public @ResponseBody
	void editConsMultiple(
			@RequestBody List<Map<String, String>> actaInfraccionArray,
			@RequestParam(value = "atcodigo", required = true) String atcodigo,
			HttpServletResponse response) {
		try {
			ArrayList<ActaInfraccion> actaInfraccionList = new ArrayList<ActaInfraccion>();

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);
			for (Map<String, String> actaInfraccion : actaInfraccionArray) {
				ActaInfraccion actaInfraccionObj = new ActaInfraccion();
				for (Map.Entry<String, String> entry : actaInfraccion
						.entrySet()) {
					if (entry.getKey().equals("aicodigo")) {
						actaInfraccionObj.setAicodigo(entry.getValue());
					} else {
						actaInfraccionObj.setAiinexii(entry.getValue());
					}

				}
				actaInfraccionObj.setActuacion(actuacion);
				actaInfraccionList.add(actaInfraccionObj);
			}

			this.actaInfraccionService
					.updateConstatacionMultiple(actaInfraccionList);
			logger.info("Entity correctly inserted!");
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param actaInfraccion
	 *            ActaInfraccion
	 * @return ActaInfraccion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	ActaInfraccion add(@RequestBody ActaInfraccion actaInfraccion) {
		try {
			ActaInfraccion actaInfraccionAux = this.actaInfraccionService
					.add(actaInfraccion);
			logger.info("Entity correctly inserted!");
			return actaInfraccionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addConstatacion'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param tticodigo
	 *            String
	 * @param ttinombre
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return ActaInfraccion
	 */
	@RequestMapping(value = "/addConstatacion", method = RequestMethod.POST)
	public @ResponseBody
	ActaInfraccion addConstatacion(
			@RequestParam(value = "atcodigo", required = true) String atcodigo,
			@RequestParam(value = "tticodigo", required = true) String tticodigo,
			@RequestParam(value = "ttinombre", required = true) String ttinombre,
			HttpServletResponse response) {
		try {

			Actuacion actuacion = new Actuacion();
			TipReqNormativo tipReqNormativo = new TipReqNormativo();

			actuacion.setAtcodigo(atcodigo);

			tipReqNormativo.setTticodigo(tticodigo);
			tipReqNormativo.setTtinombre(ttinombre);

			ActaInfraccion actaInfraccion = new ActaInfraccion();

			actaInfraccion.setActuacion(actuacion);
			actaInfraccion.setTipReqNormativo(tipReqNormativo);
			actaInfraccion.setAiinexii(Y41aConstantes.SI);

			ActaInfraccion actaInfraccionAux = this.actaInfraccionService
					.addConstatacion(actaInfraccion);
			logger.info("Entity correctly inserted!");
			return actaInfraccionAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param aicodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{aicodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String aicodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			ActaInfraccion actaInfraccion = new ActaInfraccion();
			actaInfraccion.setAicodigo(aicodigo);
			this.actaInfraccionService.remove(actaInfraccion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + aicodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeConstatacion'.
	 * 
	 * @param codigoActuacion
	 *            String
	 * @param codigoConstatacion
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeConstacion/{codigoActuacion}/{codigoConstatacion}", method = RequestMethod.DELETE)
	public void removeConstatacion(@PathVariable String codigoActuacion,
			@PathVariable String codigoConstatacion,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(codigoActuacion);

			ActaInfraccion actaInfraccion = new ActaInfraccion();
			actaInfraccion.setActuacion(actuacion);
			actaInfraccion.setAicodigo(codigoConstatacion);

			this.actaInfraccionService.removeActaInfraccion(actaInfraccion);

			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + codigoActuacion);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param actaInfraccionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> actaInfraccionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<ActaInfraccion> actaInfraccionList = new ArrayList<ActaInfraccion>();
		try {
			for (ArrayList<String> actaInfraccionId : actaInfraccionIds) {
				Iterator<String> iterator = actaInfraccionId.iterator();
				ActaInfraccion actaInfraccion = new ActaInfraccion();
				actaInfraccion.setAicodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				actaInfraccionList.add(actaInfraccion);
			}
			this.actaInfraccionService.removeMultiple(actaInfraccionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getActaInfraccionService'.
	 * 
	 * @return ActaInfraccionService
	 */
	protected ActaInfraccionService getActaInfraccionService() {
		return this.actaInfraccionService;
	}

	/**
	 * Method 'setActaInfraccionService'.
	 * 
	 * @param actaInfraccionService
	 *            ActaInfraccionService
	 * @return
	 */
	public void setActaInfraccionService(
			ActaInfraccionService actaInfraccionService) {
		this.actaInfraccionService = actaInfraccionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
