package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Acta;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.PlantillaCartaInspeccionDetalle;
import com.ejie.y41a.service.ActaFileService;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.ActaFile;

/**
 * * ActaFileController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/actafile")
public class ActaFileController {

	private static final Logger logger = LoggerFactory
			.getLogger(ActaFileController.class);

	@Autowired
	private ActaFileService actaFileService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("actafile", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param s3codocumento
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{s3codocumento}", method = RequestMethod.GET)
	public @ResponseBody
	ActaFile getById(@PathVariable String s3codocumento) {
		try {
			ActaFile actaFile = new ActaFile();
			actaFile.setS3codocumento(s3codocumento);
			actaFile = this.actaFileService.find(actaFile);
			if (actaFile == null) {
				throw new Exception(s3codocumento.toString());
			}
			return actaFile;
		} catch (Exception e) {
			throw new ResourceNotFoundException(s3codocumento.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param s3codocumento
	 *            String
	 * @param actaAccodigo
	 *            String
	 * @param s3nomfile
	 *            String
	 * @param s3sizefile
	 *            Integer
	 * @param s3desfile
	 *            String
	 * @param s3fecha
	 *            Date
	 * @param s3origen
	 *            String
	 * @param s3contenttype
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "s3codocumento", required = false) String s3codocumento,
			@RequestParam(value = "actaAccodigo", required = false) String actaAccodigo,
			@RequestParam(value = "s3nomfile", required = false) String s3nomfile,
			@RequestParam(value = "s3sizefile", required = false) Integer s3sizefile,
			@RequestParam(value = "s3desfile", required = false) String s3desfile,
			@RequestParam(value = "s3fecha", required = false) Date s3fecha,
			@RequestParam(value = "s3origen", required = false) String s3origen,
			@RequestParam(value = "s3contenttype", required = false) String s3contenttype,
			HttpServletRequest request) {
		try {

			ActaFile filterActaFile = new ActaFile(s3codocumento, s3nomfile,
					null, s3sizefile, s3desfile, s3fecha, s3origen,
					s3contenttype, new Acta(actaAccodigo, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ActaFile> actaFiles = this.actaFileService.findAll(
						filterActaFile, pagination);

				if (actaFiles == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterActaFile, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(actaFiles);
				return data;
			} else {
				List<ActaFile> actaFiles = this.actaFileService.findAll(
						filterActaFile, pagination);
				if (actaFiles == null) {
					throw new Exception("No data Found.");
				}
				return actaFiles;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterActaFile
	 *            ActaFile
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "actaFile", required = false) ActaFile filterActaFile,
			HttpServletRequest request) {
		try {
			return actaFileService
					.findAllCount(filterActaFile != null ? filterActaFile
							: new ActaFile());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param actaFile
	 *            ActaFile
	 * @param response
	 *            HttpServletResponse
	 * @return ActaFile
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	ActaFile edit(@RequestBody ActaFile actaFile, HttpServletResponse response) {
		try {
			ActaFile actaFileAux = this.actaFileService.update(actaFile);
			logger.info("Entity correctly inserted!");
			return actaFileAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param actaFile
	 *            ActaFile
	 * @return ActaFile
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	ActaFile add(@RequestBody ActaFile actaFile) {
		try {
			ActaFile actaFileAux = this.actaFileService.add(actaFile);
			logger.info("Entity correctly inserted!");
			return actaFileAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param s3codocumento
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{s3codocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String s3codocumento,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			ActaFile actaFile = new ActaFile();
			actaFile.setS3codocumento(s3codocumento);
			this.actaFileService.remove(actaFile);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + s3codocumento);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeDocumentoActa'.
	 * 
	 * @param s3codocumento
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeDocumentoActa/{s3codocumento}/{accodigo}", method = RequestMethod.DELETE)
	public void removeDocumento(@PathVariable String s3codocumento,
			@PathVariable String accodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			ActaFile actaFile = new ActaFile();
			Acta acta = new Acta();
			acta.setAccodigo(accodigo);
			actaFile.setActa(acta);
			actaFile.setS3codocumento(s3codocumento);
			this.actaFileService.remove(actaFile);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + s3codocumento);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param actaFileIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> actaFileIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<ActaFile> actaFileList = new ArrayList<ActaFile>();
		try {
			for (ArrayList<String> actaFileId : actaFileIds) {
				Iterator<String> iterator = actaFileId.iterator();
				ActaFile actaFile = new ActaFile();
				actaFile.setS3codocumento(ObjectConversionManager.convert(
						iterator.next(), String.class));
				actaFileList.add(actaFile);
			}
			this.actaFileService.removeMultiple(actaFileList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getActaFileService'.
	 * 
	 * @return ActaFileService
	 */
	protected ActaFileService getActaFileService() {
		return this.actaFileService;
	}

	/**
	 * Method 'setActaFileService'.
	 * 
	 * @param actaFileService
	 *            ActaFileService
	 * @return
	 */
	public void setActaFileService(ActaFileService actaFileService) {
		this.actaFileService = actaFileService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'addDocumentoDecision'.
	 * 
	 * @param file
	 *            MultipartFile
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "subidaDocumentoActa", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addDocumentoActa(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			String s3desfile = request.getParameter("s3desfile");
			String s3origen = request.getParameter("s3origen");
			String accodigo = request.getParameter("accodigo");

			Acta acta = new Acta();
			acta.setAccodigo(accodigo);

			ActaFile actaFile = new ActaFile();

			actaFile.setActa(acta);
			actaFile.setS3desfile(s3desfile);
			actaFile.setS3origen(s3origen);
			actaFile.setS3fecha(new Date());

			if (file != null) {
				Blob blob = new SerialBlob(file.getBytes());

				actaFile.setS3datafile(blob);
				actaFile.setS3nomfile(file.getOriginalFilename());
				actaFile.setS3contenttype(file.getContentType());
				actaFile.setS3sizefile((int) file.getSize());
			}

			ActaFile actaFileAux = this.actaFileService.addActaFile(actaFile);

			logger.info("Entity correctly update!" + actaFileAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			if (file != null) {
				filesMetaInfo.add(this.getFileReturnMap(file));
			}
			return filesMetaInfo;

		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed addDocumentoDecision");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno
				.put("url",
						"../analisis/subidaDocumentoActa/"
								+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno
				.put("delete_url",
						"../analisis/subidaDocumentoActa/"
								+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'getByIdDocumentoActaDetalle'.
	 * 
	 * @param cofile
	 *            Long
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "documentofile/{cofile}", method = RequestMethod.GET)
	public @ResponseBody
	void getByIdDocumentoActaDetalle(@PathVariable String cofile,
			HttpServletResponse response) {
		try {

			ActaFile actaFile = new ActaFile();
			actaFile.setS3codocumento(cofile);

			actaFile = this.actaFileService.find(actaFile);

			if (actaFile == null) {
				throw new Exception(cofile.toString());
			}

			Blob contenido = actaFile.getS3datafile();

			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename="
					+ actaFile.getS3nomfile() + "");
			response.setContentType(actaFile.getS3contenttype());
			// response.setContentLength(actaFile.getS3sizefile());
			response.flushBuffer();
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

			// return documentoConsultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cofile.toString());
		}
	}

	/**
	 * Method 'generarCartasInspecciones'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param accodigo
	 *            String
	 * @param inscodcarta
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/generarCartaInspecciones", method = RequestMethod.PUT)
	public @ResponseBody()
	void generarCartasInspecciones(
			@RequestParam(value = "atcodigo", required = true) String atcodigo,
			@RequestParam(value = "accodigo", required = true) String accodigo,
			@RequestParam(value = "inscodcarta", required = true) String inscodcarta,
			HttpServletRequest request) {

		try {

			PlantillaCartaInspeccionDetalle plantillaCartaInspeccionDetalle = new PlantillaCartaInspeccionDetalle();
			plantillaCartaInspeccionDetalle.setAtcodigo(atcodigo);
			plantillaCartaInspeccionDetalle.setAccodigo(accodigo);
			plantillaCartaInspeccionDetalle.setInscodcarta(inscodcarta);

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);
			String codOrgConectado = censoMonitor.getOrganismo().getCodOrg();

			plantillaCartaInspeccionDetalle.setCodOrg(codOrgConectado);

			this.actaFileService
					.generarCartasInspecciones(plantillaCartaInspeccionDetalle);

		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}
}
