package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Inspector;
import com.ejie.y41a.model.Tipodoc;
import com.ejie.y41a.service.ActaService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Acta;

/**
 * * ActaController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/acta")
public class ActaController {

	private static final Logger logger = LoggerFactory
			.getLogger(ActaController.class);

	@Autowired
	private ActaService actaService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("acta", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param accodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{accodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Acta getById(@PathVariable String accodigo) {
		try {
			Acta acta = new Acta();
			acta.setAccodigo(accodigo);
			acta = this.actaService.find(acta);
			if (acta == null) {
				throw new Exception(accodigo.toString());
			}
			return acta;
		} catch (Exception e) {
			throw new ResourceNotFoundException(accodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param accodigo
	 *            String
	 * @param inspectorIncodigo
	 *            String
	 * @param inspectorIncodigo
	 *            String
	 * @param tipodocTdcodigo
	 *            String
	 * @param establecimientoEscodigo
	 *            String
	 * @param accoor
	 *            String
	 * @param acnror
	 *            String
	 * @param acnran
	 *            BigDecimal
	 * @param acfele
	 *            Date
	 * @param acfere
	 *            Date
	 * @param accoav
	 *            String
	 * @param accose
	 *            String
	 * @param acfeex
	 *            Date
	 * @param acinre
	 *            String
	 * @param acnoco
	 *            String
	 * @param acape1co
	 *            String
	 * @param acape2co
	 *            String
	 * @param acdnico
	 *            String
	 * @param accoco
	 *            String
	 * @param acdirco
	 *            String
	 * @param accoloco
	 *            String
	 * @param acnrcpco
	 *            String
	 * @param acnrtfco
	 *            String
	 * @param acnoraPaisId
	 *            String
	 * @param acnoraPaisNombre
	 *            String
	 * @param acnoraProvinciaId
	 *            String
	 * @param acnombreProvincia
	 *            String
	 * @param acnoraMunicipioId
	 *            String
	 * @param acnombreMunicipio
	 *            String
	 * @param acnoraLocalidadId
	 *            String
	 * @param acnombreLocalidad
	 *            String
	 * @param acnoraCalleId
	 *            String
	 * @param acnombreCalle
	 *            String
	 * @param acnoraCpId
	 *            String
	 * @param acnombreCp
	 *            String
	 * @param acnoraPortalId
	 *            String
	 * @param acnombrePortal
	 *            String
	 * @param acnombrePiso
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "accodigo", required = false) String accodigo,
			@RequestParam(value = "inspectorIncodigo", required = false) String inspectorIncodigo,
			@RequestParam(value = "inspectorIncodigo2", required = false) String inspectorIncodigo2,
			@RequestParam(value = "tipodocTdcodigo", required = false) String tipodocTdcodigo,
			@RequestParam(value = "establecimientoEscodigo", required = false) String establecimientoEscodigo,
			@RequestParam(value = "accoor", required = false) String accoor,
			@RequestParam(value = "acnror", required = false) String acnror,
			@RequestParam(value = "acnran", required = false) BigDecimal acnran,
			@RequestParam(value = "acfele", required = false) Date acfele,
			@RequestParam(value = "acfere", required = false) Date acfere,
			@RequestParam(value = "accoav", required = false) String accoav,
			@RequestParam(value = "accose", required = false) String accose,
			@RequestParam(value = "acfeex", required = false) Date acfeex,
			@RequestParam(value = "acinre", required = false) String acinre,
			@RequestParam(value = "acnoco", required = false) String acnoco,
			@RequestParam(value = "acape1co", required = false) String acape1co,
			@RequestParam(value = "acape2co", required = false) String acape2co,
			@RequestParam(value = "acdnico", required = false) String acdnico,
			@RequestParam(value = "accoco", required = false) String accoco,
			@RequestParam(value = "acdirco", required = false) String acdirco,
			@RequestParam(value = "accoloco", required = false) String accoloco,
			@RequestParam(value = "acnrcpco", required = false) String acnrcpco,
			@RequestParam(value = "acnrtfco", required = false) String acnrtfco,
			@RequestParam(value = "acnoraPaisId", required = false) String acnoraPaisId,
			@RequestParam(value = "acnoraPaisNombre", required = false) String acnoraPaisNombre,
			@RequestParam(value = "acnoraProvinciaId", required = false) String acnoraProvinciaId,
			@RequestParam(value = "acnombreProvincia", required = false) String acnombreProvincia,
			@RequestParam(value = "acnoraMunicipioId", required = false) String acnoraMunicipioId,
			@RequestParam(value = "acnombreMunicipio", required = false) String acnombreMunicipio,
			@RequestParam(value = "acnoraLocalidadId", required = false) String acnoraLocalidadId,
			@RequestParam(value = "acnombreLocalidad", required = false) String acnombreLocalidad,
			@RequestParam(value = "acnoraCalleId", required = false) String acnoraCalleId,
			@RequestParam(value = "acnombreCalle", required = false) String acnombreCalle,
			@RequestParam(value = "acnoraCpId", required = false) String acnoraCpId,
			@RequestParam(value = "acnombreCp", required = false) String acnombreCp,
			@RequestParam(value = "acnoraPortalId", required = false) String acnoraPortalId,
			@RequestParam(value = "acnombrePortal", required = false) String acnombrePortal,
			@RequestParam(value = "acnombrePiso", required = false) String acnombrePiso,
			HttpServletRequest request) {
		try {
			Acta filterActa = new Acta(accodigo, accoor, acnror, acnran,
					acfele, acfere, accoav, accose, acfeex, acinre, acnoco,
					acape1co, acape2co, acdnico, accoco, acdirco, accoloco,
					acnrcpco, acnrtfco, acnoraPaisId, acnoraPaisNombre,
					acnoraProvinciaId, acnombreProvincia, acnoraMunicipioId,
					acnombreMunicipio, acnoraLocalidadId, acnombreLocalidad,
					acnoraCalleId, acnombreCalle, acnoraCpId, acnombreCp,
					acnoraPortalId, acnombrePortal, acnombrePiso, null,
					new Inspector(inspectorIncodigo, null, null, null, null),
					new Inspector(inspectorIncodigo2, null, null, null, null),
					new Tipodoc(tipodocTdcodigo, null, null),
					new Establecimiento(establecimientoEscodigo, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null));

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Acta> actas = this.actaService.findAll(filterActa,
						pagination);

				if (actas == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterActa, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(actas);
				return data;
			} else {
				List<Acta> actas = this.actaService.findAll(filterActa,
						pagination);
				if (actas == null) {
					throw new Exception("No data Found.");
				}
				return actas;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterActa
	 *            Acta
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "acta", required = false) Acta filterActa,
			HttpServletRequest request) {
		try {
			return actaService.findAllCount(filterActa != null ? filterActa
					: new Acta());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param acta
	 *            Acta
	 * @param response
	 *            HttpServletResponse
	 * @return Acta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Acta edit(@RequestBody Acta acta, HttpServletResponse response) {
		try {
			Acta actaAux = this.actaService.update(acta);
			logger.info("Entity correctly inserted!");
			return actaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param acta
	 *            Acta
	 * @return Acta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Acta add(@RequestBody Acta acta) {
		try {
			Acta actaAux = this.actaService.add(acta);
			logger.info("Entity correctly inserted!");
			return actaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param accodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{accodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String accodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Acta acta = new Acta();
			acta.setAccodigo(accodigo);
			this.actaService.remove(acta);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + accodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param actaIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> actaIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Acta> actaList = new ArrayList<Acta>();
		try {
			for (ArrayList<String> actaId : actaIds) {
				Iterator<String> iterator = actaId.iterator();
				Acta acta = new Acta();
				acta.setAccodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				actaList.add(acta);
			}
			this.actaService.removeMultiple(actaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getActaService'.
	 * 
	 * @return ActaService
	 */
	protected ActaService getActaService() {
		return this.actaService;
	}

	/**
	 * Method 'setActaService'.
	 * 
	 * @param actaService
	 *            ActaService
	 * @return
	 */
	public void setActaService(ActaService actaService) {
		this.actaService = actaService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
