package com.ejie.y41a.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class Y41aTelefonoValidator implements
		ConstraintValidator<Y41aTelefono, String> {

	private static Pattern mask = Pattern.compile("[0-9]{9}");
	private static final int longitudCero = 0;

	@Override
	public void initialize(Y41aTelefono constraintAnnotation) {
	}

	@Override
	public boolean isValid(String value, ConstraintValidatorContext context) {

		if (value == null
				|| value.length() == Y41aTelefonoValidator.longitudCero) {
			return true;
		} else {
			Matcher matcher = mask.matcher(value);

			if (!matcher.matches()) {
				// No cumple el patrón
				return false;
			}

			return true;
		}

	}

}