package com.ejie.y41a.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import com.ejie.y41a.utils.Y41aUtils;

public class Y41aNifValidator implements ConstraintValidator<Y41aNif, String> {

	private Pattern mask = Pattern.compile("[0-9]{8,8}[A-Z]");
	private static final int longitudCero = 0;

	@Override
	public void initialize(Y41aNif constraintAnnotation) {
	}

	@Override
	public boolean isValid(String value, ConstraintValidatorContext context) {

		if (value == null || value.length() == Y41aNifValidator.longitudCero) {
			return true;
		} else {

			Matcher matcher = mask.matcher(value);

			if (matcher.matches()) {
				char letra = Y41aUtils.calcularLetraNIF(value);

				if (letra == value.charAt(value.length() - 1)) {
					return true;
				}
				return false;
			} else {
				return false;
			}
		}
	}
}