package com.ejie.y41a.utils.tree;

import java.util.Iterator;

import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Y41aArbolOrganismos;
import com.ejie.y41a.model.Y41aGrupoOrganismoTree;
import com.ejie.y41a.model.Y41aOrganismoTree;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * 
 *  
 * 
 */
public class Y41aOrganismosTree {

	/**
     * 
     */
	private String _activeNode = "";

	/**
	 * Nodo Activo
	 * 
	 * @param key
	 *            String
	 */
	public void setActiveNode(String key) {
		this._activeNode = key;
	}

	/**
	 * Nodo Activo
	 * 
	 * @return String
	 */
	public String getActiveNode() {
		return this._activeNode;
	}

	/**
	 * Preseleccionar un nodo
	 * 
	 * @param key
	 *            String
	 * @return String
	 */
	private String printNodeKey(String key) {
		if (this._activeNode.equals(key)) {
			return "\"activate\": true, \"focus\": true, \"expand\": true, \"select\": false, \"key\": \""
					+ key + "\"";

			// activate: false, // Initial active status.
			// focus: false, // Initial focused status.
			// expand: false, // Initial expanded status.
			// select: false,

		} else {
			if (this._activeNode.startsWith(key)) {
				// return "\"activate\": false, \"key\": \"" + key + "\"";
				return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
						+ key + "\"";
			} else {
				return "\"activate\": false, \"focus\": false, \"expand\": false, \"select\": false, \"key\": \""
						+ key + "\"";
			}

		}

	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param _tree
	 *            Y42bTree
	 * @return String
	 */
	public static String obtieneJsonArbol(Y41aArbolOrganismos _tree) {
		Y41aOrganismosTree t = new Y41aOrganismosTree();
		t._activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
				: "");

		return t.getTreeStructureStr(_tree);
	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param tree
	 *            Y41aArbolOrganismos
	 * @return json tree
	 */
	private String getTreeStructureStr(Y41aArbolOrganismos tree) {

		// Pintar arbolito
		StringBuffer aux = new StringBuffer();

		try {
			aux.append("["); // [

			Iterator<Y41aGrupoOrganismoTree> itGr = tree.getLstGrupos()
					.iterator();
			Y41aGrupoOrganismoTree grupo = null;
			while (itGr.hasNext()) {
				grupo = itGr.next();
				aux.append(this.bloqueGrupos(grupo));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");
		} catch (Exception e1) {
			e1.printStackTrace();
		}

		return aux.toString();
	}

	/**
	 * BloqueGrupos
	 * 
	 * @param grupo
	 *            Y41aGrupoOrganismoTree
	 * @return String
	 */
	private String bloqueGrupos(Y41aGrupoOrganismoTree grupo) {
		StringBuffer aux = new StringBuffer(Y41aConstantes.BUFFER_300);

		String key = grupo.getGrupoId();
		// aux.append("{\"title\": \""
		// + Y41aUtils.printTreeLabel(grupo.getNombreEs(),
		// grupo.getNombreEu()) + "\", ");

		aux.append("{\"title\": \""
		// + "<span class='arbol_grupo'>"
				+ Y41aUtils.printTreeLabel(grupo.getNombreEs(),
						grupo.getNombreEu())
				// + "</span>"
				+ "\", ");

		aux.append("\"isFolder\": false, ");
		aux.append("\"addClass\": \"arbol_grupo\", ");

		aux.append(this.printNodeKey(key));

		if (grupo.getLstChildren().size() > 0) {
			aux.append(",");
			aux.append("\"children\": [");

			Iterator<?> itGr = grupo.getLstChildren().iterator();
			Object child = null;
			while (itGr.hasNext()) {
				child = itGr.next();
				if (child instanceof Y41aGrupoOrganismoTree) {
					aux.append(this
							.bloqueGrupos((Y41aGrupoOrganismoTree) child));
				} else {
					aux.append(this.addChild(child));
				}
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");

		}
		aux.append("}");

		return aux.toString();
	}

	/**
	 * Añadir hijos
	 * 
	 * @param child
	 *            Object
	 * @return String
	 */
	private String addChild(Object child) {
		Y41aOrganismoTree y41aOrganismoTree = null;
		StringBuffer aux = new StringBuffer();

		if (child instanceof Y41aGrupoOrganismoTree) {
			aux.append("{\"title\": \""
			// + "<span class='arbol_grupo'>"
					+ Y41aUtils.printTreeLabel(
							((Y41aGrupoOrganismoTree) child).getNombreEs(),
							((Y41aGrupoOrganismoTree) child).getNombreEu())
					// + "</span>"
					+ "\",");
			aux.append("\"isFolder\": false, ");
			String key = ((Y41aGrupoOrganismoTree) child).getGrupoId();
			aux.append("\"addClass\": \"arbol_grupo\", ");
			aux.append(this.printNodeKey(key));
			aux.append("}");

		} else if (child instanceof Y41aOrganismoTree) {

			y41aOrganismoTree = (Y41aOrganismoTree) child;

			aux.append("{\"title\": \""
			// + "<span class='arbol_entidad'>"
					+ Y41aUtils.printTreeLabel(y41aOrganismoTree.getNombreEs(),
							y41aOrganismoTree.getNombreEu())
					// + "</span>"
					+ "\",");

			StringBuffer key = new StringBuffer(Y41aConstantes.NUM_128);
			key.append(y41aOrganismoTree.getGrupoId());
			key.append("#");
			key.append("E_");
			key.append(y41aOrganismoTree.getCodOrg());

			aux.append("\"addClass\": \"arbol_entidad\", ");
			aux.append(this.printNodeKey(key.toString()));

			aux.append("}");

		}

		return aux.toString();
	}

}
