package com.ejie.y41a.utils.jdbc;

import java.sql.Blob;
import java.sql.SQLException;

public class Y41aJdbcUtils {
	private static Y41aJdbcUtils INSTANCE = null;

	// Private constructor suppresses
	private Y41aJdbcUtils() {

	}

	// creador sincronizado para protegerse de posibles problemas multi-hilo
	// otra prueba para evitar instanciación múltiple
	private synchronized static void createInstance() {
		if (INSTANCE == null) {
			INSTANCE = new Y41aJdbcUtils();
		}
	}

	public static Y41aJdbcUtils getInstance() {
		if (INSTANCE == null)
			createInstance();
		return INSTANCE;
	}

	/**
	 * Convierto un Blob a un byte[]
	 * 
	 * @param blob
	 * @return byte[]
	 */
	public static byte[] ConvertBlobToByte(Blob blob) {
		byte[] raw = null;

		try {

			raw = blob.getBytes(1, (int) blob.length());

		} catch (SQLException e) {
			return null;
		}

		return raw;
	}
}
