package com.ejie.y41a.utils.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Y41aConfig {

	/**
	 * Static method to obtain properties
	 * 
	 * @param nombreFichero
	 * @return properties
	 */
	public static Properties loadProperties(String nombreFichero) {
		return getProperties(nombreFichero);

	}

	/**
	 * Método que carga el fichero de propiedades
	 * 
	 * @param nombreFichero
	 *            String
	 * @return Properties
	 */
	public static Properties getProperties(String nombreFichero) {

		String propertiesLog = nombreFichero;
		InputStream configLog = Y41aConfig.class
				.getResourceAsStream(propertiesLog);
		Properties pLog = new Properties();

		try {
			pLog.load(configLog);
		} catch (IOException e) {
			e.printStackTrace();
		}

		return pLog;
	}
}
