package com.ejie.y41a.utils;

public class Y41aStringUtils {

	/**
	 * Constructor privado para clase estática
	 */
	private Y41aStringUtils() {

	}

	/**
	 * Sustituye entidades HTML por sus caracteres problemáticos
	 * 
	 * @param s
	 *            cadena de texto
	 * @param f
	 *            posición inicial desde la que empezar a sustituir
	 * @return cadena de texto procesada
	 */
	public static final String unescapeHTML(String s, int f) {
		String[][] escape = { { "&lt;", "<" }, { "&gt;", ">" },
				{ "&amp;", "&" }, { "&quot;", "\"" }, { "&aacute;", "á" },
				{ "&acute;", "´" }, { "&Aacute;", "Á" }, { "&eacute;", "é" },
				{ "&Eacute;", "É" }, { "&iacute;", "í" }, { "&Iacute;", "Í" },
				{ "&oacute;", "ó" }, { "&Oacute;", "Ó" }, { "&uacute;", "ú" },
				{ "&Uacute;", "Ú" }, { "&ntilde;", "ñ" }, { "&Ntilde;", "Ñ" },
				{ "&apos;", "'" }, { "&deg;", "º" }, { "&agrave;", "à" },
				{ "&Agrave;", "À" }, { "&acirc;", "â" }, { "&auml;", "ä" },
				{ "&Auml;", "Ä" }, { "&Acirc;", "Â" }, { "&aring;", "å" },
				{ "&Aring;", "Å" }, { "&aelig;", "æ" }, { "&AElig;", "Æ" },
				{ "&ccedil;", "ç" }, { "&Ccedil;", "Ç" }, { "&eacute;", "é" },
				{ "&Eacute;", "É" }, { "&egrave;", "è" }, { "&Egrave;", "È" },
				{ "&ecirc;", "ê" }, { "&Ecirc;", "Ê" }, { "&euml;", "ë" },
				{ "&Euml;", "Ë" }, { "&iuml;", "ï" }, { "&Iuml;", "Ï" },
				{ "&ocirc;", "ô" }, { "&Ocirc;", "Ô" }, { "&ouml;", "ö" },
				{ "&Ouml;", "Ö" }, { "&oslash;", "ø" }, { "&Oslash;", "Ø" },
				{ "&szlig;", "ß" }, { "&ugrave;", "ù" }, { "&Ugrave;", "Ù" },
				{ "&ucirc;", "û" }, { "&Ucirc;", "Û" }, { "&uuml;", "ü" },
				{ "&Uuml;", "Ü" }, { "&nbsp;", " " }, { "&reg;", "\u00a9" },
				{ "&copy;", "\u00ae" }, { "&euro;", "\\\\'80" },
				{ "&Ccedil;", "Ç" }, { "&ccedil;", "ç" }, { "&uml;", "¨" },
				{ "&iquest;", "¿" }, { "&middot;", "·" },
				{ "&lineSeparator;", "{\\\\par \\\\pard}" },
				{ "&separator;", "{\\\\sb \\\\sb}" },
				{ "&negritaini;", "\\\\b " },
				{ "&negritafin;", "\\\\b0 \\\\'20" },
				{ "&italicini;", "\\\\i " },
				{ "&italicfin;", "\\\\i0 \\\\'20" },
				{ "&subrayadoini;", "\\\\ul " },
				{ "&subrayadofin;", "\\\\ul0 \\\\'20" },
				{ "&bullet;", "\\\\'95" }, { "&tachadoini;", "\\\\strike" },
				{ "&tachadofin;", "\\\\strike0" },

		};
		int i, j, k;

		if (s != null) {
			i = s.indexOf("&", f);
			if (i > -1) {
				j = s.indexOf(";", i);
				// --------
				// we don't start from the beginning
				// the next time, to handle the case of
				// the &
				// thanks to Pieter Hertogh for the bug fix!
				f = i + 1;
				// --------
				if (j > i) {
					// ok this is not most optimized way to
					// do it, a StringBuffer would be better,
					// this is left as an exercise to the reader!
					String temp = s.substring(i, j + 1);
					// search in escape[][] if temp is there
					k = 0;
					while (k < escape.length) {
						if (escape[k][0].equals(temp))
							break;
						else
							k++;
					}
					if (k < escape.length) {
						s = s.substring(0, i) + escape[k][1]
								+ s.substring(j + 1);
						return unescapeHTML(s, f); // recursive call
					}
				}
			}
		}
		return s;
	}

	/**
	 * Sustituye caracteres problematicos por sus entidades HTML
	 * 
	 * @param s
	 *            cadena de texto
	 * @return cadena de texto procesada
	 */
	// public static final String escapeHTML(String s) {
	// StringBuffer sb = new StringBuffer();
	// int n = s.length();
	// for (int i = 0; i < n; i++) {
	// char c = s.charAt(i);
	// switch (c) {
	// case '<':
	// sb.append("&lt;");
	// break;
	// case '>':
	// sb.append("&gt;");
	// break;
	// case '&':
	// sb.append("&amp;");
	// break;
	// case '"':
	// sb.append("&quot;");
	// break;
	// case 'à':
	// sb.append("&agrave;");
	// break;
	// case 'À':
	// sb.append("&Agrave;");
	// break;
	// case 'â':
	// sb.append("&acirc;");
	// break;
	// case 'Â':
	// sb.append("&Acirc;");
	// break;
	// case 'ä':
	// sb.append("&auml;");
	// break;
	// case 'Ä':
	// sb.append("&Auml;");
	// break;
	// case 'å':
	// sb.append("&aring;");
	// break;
	// case 'Å':
	// sb.append("&Aring;");
	// break;
	// case 'æ':
	// sb.append("&aelig;");
	// break;
	// case 'Æ':
	// sb.append("&AElig;");
	// break;
	// case 'ç':
	// sb.append("&ccedil;");
	// break;
	// case 'Ç':
	// sb.append("&Ccedil;");
	// break;
	// case 'é':
	// sb.append("&eacute;");
	// break;
	// case 'É':
	// sb.append("&Eacute;");
	// break;
	// case 'è':
	// sb.append("&egrave;");
	// break;
	// case 'È':
	// sb.append("&Egrave;");
	// break;
	// case 'ê':
	// sb.append("&ecirc;");
	// break;
	// case 'Ê':
	// sb.append("&Ecirc;");
	// break;
	// case 'ë':
	// sb.append("&euml;");
	// break;
	// case 'Ë':
	// sb.append("&Euml;");
	// break;
	// case 'ï':
	// sb.append("&iuml;");
	// break;
	// case 'Ï':
	// sb.append("&Iuml;");
	// break;
	// case 'ô':
	// sb.append("&ocirc;");
	// break;
	// case 'Ô':
	// sb.append("&Ocirc;");
	// break;
	// case 'ö':
	// sb.append("&ouml;");
	// break;
	// case 'Ö':
	// sb.append("&Ouml;");
	// break;
	// case 'ø':
	// sb.append("&oslash;");
	// break;
	// case 'Ø':
	// sb.append("&Oslash;");
	// break;
	// case 'ß':
	// sb.append("&szlig;");
	// break;
	// case 'ù':
	// sb.append("&ugrave;");
	// break;
	// case 'Ù':
	// sb.append("&Ugrave;");
	// break;
	// case 'û':
	// sb.append("&ucirc;");
	// break;
	// case 'Û':
	// sb.append("&Ucirc;");
	// break;
	// case 'ü':
	// sb.append("&uuml;");
	// break;
	// case 'Ü':
	// sb.append("&Uuml;");
	// break;
	// case '®':
	// sb.append("&reg;");
	// break;
	// case '©':
	// sb.append("&copy;");
	// break;
	// case '€':
	// sb.append("&euro;");
	// break;
	// // be carefull with this one (non-breaking whitee space)
	// case ' ':
	// sb.append("&nbsp;");
	// break;
	//
	// default:
	// sb.append(c);
	// break;
	// }
	// }
	// return sb.toString();
	// }

}