package com.ejie.y41a.service;

import java.util.Date;

import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.SolicitudBusqueda;

/**
 *  
 */
public interface Y41aExcelGeneratorService {

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en consultas
	 * 
	 * @param consulta
	 *            Consulta
	 * @param fechaDesde
	 *            Date rango inferior de fechas
	 * @param fechaHasta
	 *            Date rango superior de fechas
	 * @return String
	 */
	String getConsultasExcel(Consulta consulta, Date fechaDesde, Date fechaHasta);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param solicitudBusqueda
	 *            SolicitudBusqueda
	 * @param fechaPresentacionDesde
	 *            Date rango inferior de fecha de presentación
	 * @param fechaPresentacionHasta
	 *            Date rango superior de fechas de presentación
	 * @param fechaRegistroDesde
	 *            Date rango inferior de fecha de registro
	 * @param fechaRegistroHasta
	 *            Date rango superior de fechas de registro
	 * @param fechaDecisionDesde
	 *            Date rango inferior de fecha de decisión
	 * @param fechaDecisionHasta
	 *            Date rango superior de fechas de decisión
	 * @return String
	 */
	public String getSolicitudesExcel(SolicitudBusqueda solicitudBusqueda,
			Date fechaPresentacionDesde, Date fechaPresentacionHasta,
			Date fechaRegistroDesde, Date fechaRegistroHasta,
			Date fechaDescisionDesde, Date fechaDescisionHasta);

}
