package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TrasladoDao;
import com.ejie.y41a.model.Traslado;
import com.ejie.y41a.model.TrasladoBusqueda;

/**
 * * TrasladoServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 * 
 *  
 */

@Service(value = "trasladoService")
public class TrasladoServiceImpl implements TrasladoService {

	private static final Logger logger = LoggerFactory
			.getLogger(TrasladoServiceImpl.class);
	@Autowired
	private TrasladoDao trasladoDao;

	/**
	 * Inserts a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Traslado add(Traslado traslado) {
		return this.trasladoDao.add(traslado);
	}

	/**
	 * Inserts a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Traslado addTraslado(Traslado traslado) {
		return this.trasladoDao.addTraslado(traslado);
	}

	/**
	 * Updates a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Traslado update(Traslado traslado) {
		return this.trasladoDao.update(traslado);
	}

	/**
	 * Updates a single row in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return TrasladoBusqueda
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TrasladoBusqueda updateTraslado(TrasladoBusqueda trasladoBusqueda) {
		return this.trasladoDao.updateTraslado(trasladoBusqueda);
	}

	/**
	 * Finds a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	public Traslado find(Traslado traslado) {
		return (Traslado) this.trasladoDao.find(traslado);
	}

	/**
	 * Finds a single row in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return TrasladoBusqueda
	 */
	public TrasladoBusqueda findTraslado(TrasladoBusqueda trasladoBusqueda) {
		return (TrasladoBusqueda) this.trasladoDao
				.findTraslado(trasladoBusqueda);
	}

	/**
	 * Finds a List of rows in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Traslado> findAll(Traslado traslado, Pagination pagination) {
		return (List<Traslado>) this.trasladoDao.findAll(traslado, pagination);
	}

	/**
	 * Counts rows in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Long
	 */
	public Long findAllCount(Traslado traslado) {
		return this.trasladoDao.findAllCount(traslado);
	}

	/**
	 * Finds rows in the Traslado table using like.
	 * 
	 * @param traslado
	 *            Traslado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Traslado> findAllLike(Traslado traslado, Pagination pagination,
			Boolean startsWith) {
		return (List<Traslado>) this.trasladoDao.findAllLike(traslado,
				pagination, startsWith);
	}

	/**
	 * Busca en la tabla de traslados. El receptor del traslado tiene que estar
	 * en la tabla de Organismos Solicitudes
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda filtro de busqueda
	 * @param pagination
	 *            Pagination paginacion
	 * @return List<TrasladoBusqueda>
	 */
	public List<TrasladoBusqueda> findAllTraslado(
			TrasladoBusqueda trasladoBusqueda, Pagination pagination) {

		// Control para poder paginar por un campo calculado - numeroConsulta
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("numExpediente")) {
				pagination.setSort("ihcoortr, ihnrortr, ihnrantr");
			} else if (pagination.getSort() != null
					&& pagination.getSort().equals("nombreororEs")) {
				pagination.setSort("ORGANISMOORNOMBREES");
			} else if (pagination.getSort() != null
					&& pagination.getSort().equals("nombreororEu")) {
				pagination.setSort("ORGANISMOORNOMBREEU");
			} else if (pagination.getSort() != null
					&& pagination.getSort().equals("nombreordtEs")) {
				pagination.setSort("ORGANISMODTNOMBREES");
			} else if (pagination.getSort() != null
					&& pagination.getSort().equals("nombreordtEu")) {
				pagination.setSort("ORGANISMODTNOMBREEU");
			} else if (pagination.getSort() != null
					&& pagination.getSort().equals("numSolicitud")) {
				pagination.setSort("decoor, denror, denran, hdnror");
			}
		}

		List<TrasladoBusqueda> listTrasladoBusqueda = this.trasladoDao
				.findAllTraslado(trasladoBusqueda, pagination);

		for (TrasladoBusqueda tras : listTrasladoBusqueda) {
			StringBuffer numeroExpediente = new StringBuffer();

			numeroExpediente.append(tras.getIhcoortr()).append("-")
					.append(tras.getIhnrortr()).append("-")
					.append(tras.getIhnrantr());

			tras.setNumExpediente(numeroExpediente.toString());

			StringBuffer numeroSolicitud = new StringBuffer();

			numeroSolicitud.append(tras.getDecoor()).append("-")
					.append(tras.getDenror()).append("-")
					.append(tras.getDenran()).append("-")
					.append(tras.getHdnror());

			tras.setNumSolicitud(numeroSolicitud.toString());
		}

		return listTrasladoBusqueda;
	}

	/**
	 * Counts rows in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return Long
	 */
	public Long findAllTrasladoCount(TrasladoBusqueda trasladoBusqueda) {
		return this.trasladoDao.findAllTrasladoCount(trasladoBusqueda);
	}

	/**
	 * Deletes a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Traslado traslado) {
		this.trasladoDao.remove(traslado);
	}

	/**
	 * Deletes multiple rows in the Traslado table.
	 * 
	 * @param trasladoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Traslado> trasladoList) {
		for (Traslado trasladoAux : trasladoList) {
			this.trasladoDao.remove(trasladoAux);
		}
	}

	/**
	 * Getter method for TrasladoDao
	 * 
	 * @return TrasladoDao
	 */
	public TrasladoDao getTrasladoDao() {
		return this.trasladoDao;
	}

	/**
	 * Setter method for TrasladoDao.
	 * 
	 * @param trasladoDao
	 *            TrasladoDao
	 * @return
	 */
	public void setTrasladoDao(TrasladoDao trasladoDao) {
		logger.info("Setting Dependency " + trasladoDao);
		this.trasladoDao = trasladoDao;
	}

	/**
	 * 
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda critérios de búsqueda
	 * @param pagination
	 *            Pagination paginación
	 * @return List<TrasladoBusqueda>
	 */
	public List<TrasladoBusqueda> findAllTrasladoOrgSolicidudes(
			TrasladoBusqueda trasladoBusqueda, Pagination pagination) {
		return this.trasladoDao.findAllTrasladoOrgSolicidudes(trasladoBusqueda,
				pagination);
	}

	/**
	 * Cuenta los traslados hacia organismos que pueden crear solicitudes.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda filtro de búsqueda
	 * @return Long
	 */
	public Long findAllTrasladoOrgSolicidudesCount(
			TrasladoBusqueda trasladoBusqueda) {
		return this.trasladoDao
				.findAllTrasladoOrgSolicidudesCount(trasladoBusqueda);
	}
}
