package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Traslado;
import com.ejie.y41a.model.TrasladoBusqueda;

/**
 * * TrasladoService generated by UDA, 22-feb-2012 17:30:29.
 * 
 *  
 */

public interface TrasladoService {

	/**
	 * Inserts a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	Traslado add(Traslado traslado);

	/**
	 * Inserts a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	Traslado addTraslado(Traslado traslado);

	/**
	 * Updates a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	Traslado update(Traslado traslado);

	/**
	 * Updates a single row in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return TrasladoBusqueda
	 */
	TrasladoBusqueda updateTraslado(TrasladoBusqueda trasladoBusqueda);

	/**
	 * Finds a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Traslado
	 */
	Traslado find(Traslado traslado);

	/**
	 * Finds a single row in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return TrasladoBusqueda
	 */
	TrasladoBusqueda findTraslado(TrasladoBusqueda trasladoBusqueda);

	/**
	 * Finds a List of rows in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Traslado> findAll(Traslado traslado, Pagination pagination);

	/**
	 * Counts rows in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return Long
	 */
	Long findAllCount(Traslado traslado);

	/**
	 * Finds rows in the Traslado table using like.
	 * 
	 * @param traslado
	 *            Traslado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Traslado> findAllLike(Traslado traslado, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds a List of rows in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TrasladoBusqueda> findAllTraslado(TrasladoBusqueda trasladoBusqueda,
			Pagination pagination);

	/**
	 * Counts rows in the Traslado table.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda
	 * @return Long
	 */
	Long findAllTrasladoCount(TrasladoBusqueda trasladoBusqueda);

	/**
	 * Deletes a single row in the Traslado table.
	 * 
	 * @param traslado
	 *            Traslado
	 * @return
	 */
	void remove(Traslado traslado);

	/**
	 * Deletes multiple rows in the Traslado table.
	 * 
	 * @param trasladoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Traslado> trasladoList);

	/**
	 * Busca en la tabla de traslados los traslados hacia organismos que pueden
	 * crear solicitudes.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda critérios de búsqueda
	 * @param pagination
	 *            Pagination paginación
	 * @return List<TrasladoBusqueda>
	 */
	List<TrasladoBusqueda> findAllTrasladoOrgSolicidudes(
			TrasladoBusqueda trasladoBusqueda, Pagination pagination);

	/**
	 * Cuenta los traslados hacia organismos que pueden crear solicitudes.
	 * 
	 * @param trasladoBusqueda
	 *            TrasladoBusqueda filtro de búsqueda
	 * @return Long
	 */
	Long findAllTrasladoOrgSolicidudesCount(TrasladoBusqueda trasladoBusqueda);

}
