package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.PlantillaTramiteDao;
import com.ejie.y41a.dao.TramiteDao;
import com.ejie.y41a.model.PlantillaTramite;
import com.ejie.y41a.model.Tramite;
import com.ejie.y41a.model.TramiteHecho;
import com.ejie.y41a.utils.Y41aUIDGenerator;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * TramiteServiceImpl generated by UDA, 05-mar-2012 9:11:43.
 * 
 *  
 */

@Service(value = "tramiteService")
public class TramiteServiceImpl implements TramiteService {

	private static final Logger logger = LoggerFactory
			.getLogger(TramiteServiceImpl.class);
	@Autowired
	private TramiteDao tramiteDao;
	@Autowired
	private PlantillaTramiteDao plantillaTramiteDao;

	@Autowired
	private TramiteHechoService tramiteHechoService;

	/**
	 * Inserts a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tramite add(Tramite tramite) {
		return this.tramiteDao.add(tramite);
	}

	/**
	 * Inserts a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tramite addTramite(Tramite tramite) {
		tramite.setTrcodigo(this.tramiteDao.getNewPK().toString());
		this.tramiteDao.add(tramite);

		// buscar los diferentes codigos de organismo que tienen plantillas
		List<PlantillaTramite> listPlantillaTramite = this.plantillaTramiteDao
				.findAllOrganismos();

		for (PlantillaTramite plantTramite : listPlantillaTramite) {

			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcoor(plantTramite.getPtcoor());
			plantillaTramite.setTramite(tramite);
			plantillaTramite.setPtcodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));

			// por cada organismo insertar una plantilla vacia.
			this.plantillaTramiteDao.add(plantillaTramite);
		}

		if (listPlantillaTramite.size() == 0) {
			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcoor(Y41aConstantes.CODIGO_ORGANISMO_LAKUA);
			plantillaTramite.setTramite(tramite);
			plantillaTramite.setPtcodigo(Y41aUIDGenerator.getInstance()
					.generateId(Y41aConstantes.PK_SIZE));

			// por cada organismo insertar una plantilla vacia.
			this.plantillaTramiteDao.add(plantillaTramite);
		}
		return tramite;
	}

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tramite update(Tramite tramite) {
		return this.tramiteDao.update(tramite);
	}

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tramite updateFecha(Tramite tramite) {
		Tramite tramiteConsulta = new Tramite();
		tramiteConsulta.setTrcodigo(tramite.getTrcodigo());
		long contador = 0;
		TramiteHecho tramiteHecho = new TramiteHecho();
		tramiteHecho.setTramite(tramiteConsulta);
		contador = this.tramiteHechoService.findAllCount(tramiteHecho);
		if (contador > 0) {
			throw new Y41aUDAException("error.validacion.tramiteAsociado",
					true, new Exception());
		} else {
			return this.tramiteDao.updateFecha(tramite);
		}
	}

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	public Tramite find(Tramite tramite) {
		return (Tramite) this.tramiteDao.find(tramite);
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAll(Tramite tramite, Pagination pagination) {
		return (List<Tramite>) this.tramiteDao.findAll(tramite, pagination);
	}

	/**
	 * Counts rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Long
	 */
	public Long findAllCount(Tramite tramite) {
		return this.tramiteDao.findAllCount(tramite);
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllTramites(Tramite tramite, Pagination pagination) {
		return (List<Tramite>) this.tramiteDao.findAllTramites(tramite,
				pagination);
	}

	/**
	 * Counts rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Long
	 */
	public Long findAllTramitesCount(Tramite tramite) {
		return this.tramiteDao.findAllTramitesCount(tramite);
	}

	/**
	 * Finds rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Tramite> findAllLike(Tramite tramite, Pagination pagination,
			Boolean startsWith) {
		return (List<Tramite>) this.tramiteDao.findAllLike(tramite, pagination,
				startsWith);
	}

	/**
	 * Deletes a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tramite tramite) {
		this.tramiteDao.remove(tramite);
	}

	/**
	 * Deletes multiple rows in the Tramite table.
	 * 
	 * @param tramiteList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Tramite> tramiteList) {
		for (Tramite tramiteAux : tramiteList) {
			this.tramiteDao.remove(tramiteAux);
		}
	}

	/**
	 * Getter method for TramiteDao
	 * 
	 * @return TramiteDao
	 */
	public TramiteDao getTramiteDao() {
		return this.tramiteDao;
	}

	/**
	 * Setter method for TramiteDao.
	 * 
	 * @param tramiteDao
	 *            TramiteDao
	 * @return
	 */
	public void setTramiteDao(TramiteDao tramiteDao) {
		logger.info("Setting Dependency " + tramiteDao);
		this.tramiteDao = tramiteDao;
	}

	/**
	 * Busca los trámites utilizables desde añadir trámite en el detalle del
	 * hecho
	 * 
	 * @param tramite
	 *            Tramite filtro de trámite
	 * @param pagination
	 *            Pagination paginación
	 * @return List lista de trámites
	 */
	public List<Tramite> findAllTramitesAlta(Tramite tramite,
			Pagination pagination) {
		return (List<Tramite>) this.tramiteDao.findAllTramitesAlta(tramite,
				pagination);
	}

}
