package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TramiteHechoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TramiteHecho;

/**
 *  * TramiteHechoServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 *  
 */

@Service(value = "tramiteHechoService")
public  class TramiteHechoServiceImpl implements TramiteHechoService {

	private static final  Logger logger = LoggerFactory.getLogger(TramiteHechoServiceImpl.class);
	@Autowired
	private TramiteHechoDao tramiteHechoDao;

	/**
	 * Inserts a single row in the TramiteHecho table.
	 *
	 * @param tramiteHecho TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho add(TramiteHecho tramiteHecho) {
		return this.tramiteHechoDao.add(tramiteHecho);
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 *
	 * @param tramiteHecho TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho update(TramiteHecho tramiteHecho) {
		return this.tramiteHechoDao.update(tramiteHecho);
	 }

	/**
	 * Finds a single row in the TramiteHecho table.
	 *
	 * @param tramiteHecho TramiteHecho
	 * @return TramiteHecho
	 */
	public TramiteHecho find(TramiteHecho tramiteHecho) {
		return (TramiteHecho) this.tramiteHechoDao.find(tramiteHecho);
	}

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 *
	 * @param tramiteHecho TramiteHecho
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TramiteHecho> findAll(TramiteHecho tramiteHecho, Pagination pagination) {
		return (List<TramiteHecho>) this.tramiteHechoDao.findAll(tramiteHecho, pagination);
	}
    
	/**
	 * Counts rows in the TramiteHecho table.
	 *
	 * @param tramiteHecho TramiteHecho
	 * @return Long
	 */
	public Long findAllCount(TramiteHecho tramiteHecho) {        
		return  this.tramiteHechoDao.findAllCount(tramiteHecho);
	}

	/**
	 * Finds rows in the TramiteHecho table using like.
	 *
	 * @param tramiteHecho TramiteHecho
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TramiteHecho> findAllLike(TramiteHecho tramiteHecho, Pagination pagination, Boolean startsWith) {
		return (List<TramiteHecho>) this.tramiteHechoDao.findAllLike(tramiteHecho, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TramiteHecho table.
	 *
	 * @param tramiteHecho TramiteHecho
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TramiteHecho tramiteHecho) {
		this.tramiteHechoDao.remove(tramiteHecho);
	}
	
	/**
	 * Deletes multiple rows in the TramiteHecho table.
	 *
	 * @param tramiteHechoList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TramiteHecho> tramiteHechoList) {
		for (TramiteHecho  tramiteHechoAux:tramiteHechoList) {
			this.tramiteHechoDao.remove(tramiteHechoAux);
		}
	}


	/**
	 * Getter method for TramiteHechoDao
	 *
	 * @return TramiteHechoDao
	 */
	public TramiteHechoDao getTramiteHechoDao() {
		return this.tramiteHechoDao;
	}
    
	/**
	 * Setter method for TramiteHechoDao.
	 *
	 * @param  tramiteHechoDao TramiteHechoDao
	 * @return
	 */
	public void setTramiteHechoDao(TramiteHechoDao tramiteHechoDao) {
		logger.info("Setting Dependency "+tramiteHechoDao);
		this.tramiteHechoDao = tramiteHechoDao;
	}
}

