package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipodocDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Tipodoc;

/**
 *  * TipodocServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "tipodocService")
public  class TipodocServiceImpl implements TipodocService {

	private static final  Logger logger = LoggerFactory.getLogger(TipodocServiceImpl.class);
	@Autowired
	private TipodocDao tipodocDao;

	/**
	 * Inserts a single row in the Tipodoc table.
	 *
	 * @param tipodoc Tipodoc
	 * @return Tipodoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipodoc add(Tipodoc tipodoc) {
		return this.tipodocDao.add(tipodoc);
	}

	/**
	 * Updates a single row in the Tipodoc table.
	 *
	 * @param tipodoc Tipodoc
	 * @return Tipodoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipodoc update(Tipodoc tipodoc) {
		return this.tipodocDao.update(tipodoc);
	 }

	/**
	 * Finds a single row in the Tipodoc table.
	 *
	 * @param tipodoc Tipodoc
	 * @return Tipodoc
	 */
	public Tipodoc find(Tipodoc tipodoc) {
		return (Tipodoc) this.tipodocDao.find(tipodoc);
	}

	/**
	 * Finds a List of rows in the Tipodoc table.
	 *
	 * @param tipodoc Tipodoc
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Tipodoc> findAll(Tipodoc tipodoc, Pagination pagination) {
		return (List<Tipodoc>) this.tipodocDao.findAll(tipodoc, pagination);
	}
    
	/**
	 * Counts rows in the Tipodoc table.
	 *
	 * @param tipodoc Tipodoc
	 * @return Long
	 */
	public Long findAllCount(Tipodoc tipodoc) {        
		return  this.tipodocDao.findAllCount(tipodoc);
	}

	/**
	 * Finds rows in the Tipodoc table using like.
	 *
	 * @param tipodoc Tipodoc
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Tipodoc> findAllLike(Tipodoc tipodoc, Pagination pagination, Boolean startsWith) {
		return (List<Tipodoc>) this.tipodocDao.findAllLike(tipodoc, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the Tipodoc table.
	 *
	 * @param tipodoc Tipodoc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tipodoc tipodoc) {
		this.tipodocDao.remove(tipodoc);
	}
	
	/**
	 * Deletes multiple rows in the Tipodoc table.
	 *
	 * @param tipodocList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Tipodoc> tipodocList) {
		for (Tipodoc  tipodocAux:tipodocList) {
			this.tipodocDao.remove(tipodocAux);
		}
	}


	/**
	 * Getter method for TipodocDao
	 *
	 * @return TipodocDao
	 */
	public TipodocDao getTipodocDao() {
		return this.tipodocDao;
	}
    
	/**
	 * Setter method for TipodocDao.
	 *
	 * @param  tipodocDao TipodocDao
	 * @return
	 */
	public void setTipodocDao(TipodocDao tipodocDao) {
		logger.info("Setting Dependency "+tipodocDao);
		this.tipodocDao = tipodocDao;
	}
}

