package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipoRespuestaDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipoRespuesta;

/**
 *  * TipoRespuestaServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 *  
 */

@Service(value = "tipoRespuestaService")
public  class TipoRespuestaServiceImpl implements TipoRespuestaService {

	private static final  Logger logger = LoggerFactory.getLogger(TipoRespuestaServiceImpl.class);
	@Autowired
	private TipoRespuestaDao tipoRespuestaDao;

	/**
	 * Inserts a single row in the TipoRespuesta table.
	 *
	 * @param tipoRespuesta TipoRespuesta
	 * @return TipoRespuesta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoRespuesta add(TipoRespuesta tipoRespuesta) {
		return this.tipoRespuestaDao.add(tipoRespuesta);
	}

	/**
	 * Updates a single row in the TipoRespuesta table.
	 *
	 * @param tipoRespuesta TipoRespuesta
	 * @return TipoRespuesta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoRespuesta update(TipoRespuesta tipoRespuesta) {
		return this.tipoRespuestaDao.update(tipoRespuesta);
	 }

	/**
	 * Finds a single row in the TipoRespuesta table.
	 *
	 * @param tipoRespuesta TipoRespuesta
	 * @return TipoRespuesta
	 */
	public TipoRespuesta find(TipoRespuesta tipoRespuesta) {
		return (TipoRespuesta) this.tipoRespuestaDao.find(tipoRespuesta);
	}

	/**
	 * Finds a List of rows in the TipoRespuesta table.
	 *
	 * @param tipoRespuesta TipoRespuesta
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipoRespuesta> findAll(TipoRespuesta tipoRespuesta, Pagination pagination) {
		return (List<TipoRespuesta>) this.tipoRespuestaDao.findAll(tipoRespuesta, pagination);
	}
    
	/**
	 * Counts rows in the TipoRespuesta table.
	 *
	 * @param tipoRespuesta TipoRespuesta
	 * @return Long
	 */
	public Long findAllCount(TipoRespuesta tipoRespuesta) {        
		return  this.tipoRespuestaDao.findAllCount(tipoRespuesta);
	}

	/**
	 * Finds rows in the TipoRespuesta table using like.
	 *
	 * @param tipoRespuesta TipoRespuesta
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipoRespuesta> findAllLike(TipoRespuesta tipoRespuesta, Pagination pagination, Boolean startsWith) {
		return (List<TipoRespuesta>) this.tipoRespuestaDao.findAllLike(tipoRespuesta, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipoRespuesta table.
	 *
	 * @param tipoRespuesta TipoRespuesta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoRespuesta tipoRespuesta) {
		this.tipoRespuestaDao.remove(tipoRespuesta);
	}
	
	/**
	 * Deletes multiple rows in the TipoRespuesta table.
	 *
	 * @param tipoRespuestaList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipoRespuesta> tipoRespuestaList) {
		for (TipoRespuesta  tipoRespuestaAux:tipoRespuestaList) {
			this.tipoRespuestaDao.remove(tipoRespuestaAux);
		}
	}


	/**
	 * Getter method for TipoRespuestaDao
	 *
	 * @return TipoRespuestaDao
	 */
	public TipoRespuestaDao getTipoRespuestaDao() {
		return this.tipoRespuestaDao;
	}
    
	/**
	 * Setter method for TipoRespuestaDao.
	 *
	 * @param  tipoRespuestaDao TipoRespuestaDao
	 * @return
	 */
	public void setTipoRespuestaDao(TipoRespuestaDao tipoRespuestaDao) {
		logger.info("Setting Dependency "+tipoRespuestaDao);
		this.tipoRespuestaDao = tipoRespuestaDao;
	}
}

