package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipoReclamacionDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipoReclamacion;

/**
 *  * TipoReclamacionServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 *  
 */

@Service(value = "tipoReclamacionService")
public  class TipoReclamacionServiceImpl implements TipoReclamacionService {

	private static final  Logger logger = LoggerFactory.getLogger(TipoReclamacionServiceImpl.class);
	@Autowired
	private TipoReclamacionDao tipoReclamacionDao;

	/**
	 * Inserts a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion TipoReclamacion
	 * @return TipoReclamacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoReclamacion add(TipoReclamacion tipoReclamacion) {
		return this.tipoReclamacionDao.add(tipoReclamacion);
	}

	/**
	 * Updates a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion TipoReclamacion
	 * @return TipoReclamacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoReclamacion update(TipoReclamacion tipoReclamacion) {
		return this.tipoReclamacionDao.update(tipoReclamacion);
	 }

	/**
	 * Finds a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion TipoReclamacion
	 * @return TipoReclamacion
	 */
	public TipoReclamacion find(TipoReclamacion tipoReclamacion) {
		return (TipoReclamacion) this.tipoReclamacionDao.find(tipoReclamacion);
	}

	/**
	 * Finds a List of rows in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion TipoReclamacion
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipoReclamacion> findAll(TipoReclamacion tipoReclamacion, Pagination pagination) {
		return (List<TipoReclamacion>) this.tipoReclamacionDao.findAll(tipoReclamacion, pagination);
	}
    
	/**
	 * Counts rows in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion TipoReclamacion
	 * @return Long
	 */
	public Long findAllCount(TipoReclamacion tipoReclamacion) {        
		return  this.tipoReclamacionDao.findAllCount(tipoReclamacion);
	}

	/**
	 * Finds rows in the TipoReclamacion table using like.
	 *
	 * @param tipoReclamacion TipoReclamacion
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipoReclamacion> findAllLike(TipoReclamacion tipoReclamacion, Pagination pagination, Boolean startsWith) {
		return (List<TipoReclamacion>) this.tipoReclamacionDao.findAllLike(tipoReclamacion, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion TipoReclamacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoReclamacion tipoReclamacion) {
		this.tipoReclamacionDao.remove(tipoReclamacion);
	}
	
	/**
	 * Deletes multiple rows in the TipoReclamacion table.
	 *
	 * @param tipoReclamacionList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipoReclamacion> tipoReclamacionList) {
		for (TipoReclamacion  tipoReclamacionAux:tipoReclamacionList) {
			this.tipoReclamacionDao.remove(tipoReclamacionAux);
		}
	}


	/**
	 * Getter method for TipoReclamacionDao
	 *
	 * @return TipoReclamacionDao
	 */
	public TipoReclamacionDao getTipoReclamacionDao() {
		return this.tipoReclamacionDao;
	}
    
	/**
	 * Setter method for TipoReclamacionDao.
	 *
	 * @param  tipoReclamacionDao TipoReclamacionDao
	 * @return
	 */
	public void setTipoReclamacionDao(TipoReclamacionDao tipoReclamacionDao) {
		logger.info("Setting Dependency "+tipoReclamacionDao);
		this.tipoReclamacionDao = tipoReclamacionDao;
	}
}

