package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipoComunicacionDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipoComunicacion;

/**
 *  * TipoComunicacionServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 *  
 */

@Service(value = "tipoComunicacionService")
public  class TipoComunicacionServiceImpl implements TipoComunicacionService {

	private static final  Logger logger = LoggerFactory.getLogger(TipoComunicacionServiceImpl.class);
	@Autowired
	private TipoComunicacionDao tipoComunicacionDao;

	/**
	 * Inserts a single row in the TipoComunicacion table.
	 *
	 * @param tipoComunicacion TipoComunicacion
	 * @return TipoComunicacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoComunicacion add(TipoComunicacion tipoComunicacion) {
		return this.tipoComunicacionDao.add(tipoComunicacion);
	}

	/**
	 * Updates a single row in the TipoComunicacion table.
	 *
	 * @param tipoComunicacion TipoComunicacion
	 * @return TipoComunicacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoComunicacion update(TipoComunicacion tipoComunicacion) {
		return this.tipoComunicacionDao.update(tipoComunicacion);
	 }

	/**
	 * Finds a single row in the TipoComunicacion table.
	 *
	 * @param tipoComunicacion TipoComunicacion
	 * @return TipoComunicacion
	 */
	public TipoComunicacion find(TipoComunicacion tipoComunicacion) {
		return (TipoComunicacion) this.tipoComunicacionDao.find(tipoComunicacion);
	}

	/**
	 * Finds a List of rows in the TipoComunicacion table.
	 *
	 * @param tipoComunicacion TipoComunicacion
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipoComunicacion> findAll(TipoComunicacion tipoComunicacion, Pagination pagination) {
		return (List<TipoComunicacion>) this.tipoComunicacionDao.findAll(tipoComunicacion, pagination);
	}
    
	/**
	 * Counts rows in the TipoComunicacion table.
	 *
	 * @param tipoComunicacion TipoComunicacion
	 * @return Long
	 */
	public Long findAllCount(TipoComunicacion tipoComunicacion) {        
		return  this.tipoComunicacionDao.findAllCount(tipoComunicacion);
	}

	/**
	 * Finds rows in the TipoComunicacion table using like.
	 *
	 * @param tipoComunicacion TipoComunicacion
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipoComunicacion> findAllLike(TipoComunicacion tipoComunicacion, Pagination pagination, Boolean startsWith) {
		return (List<TipoComunicacion>) this.tipoComunicacionDao.findAllLike(tipoComunicacion, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipoComunicacion table.
	 *
	 * @param tipoComunicacion TipoComunicacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoComunicacion tipoComunicacion) {
		this.tipoComunicacionDao.remove(tipoComunicacion);
	}
	
	/**
	 * Deletes multiple rows in the TipoComunicacion table.
	 *
	 * @param tipoComunicacionList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipoComunicacion> tipoComunicacionList) {
		for (TipoComunicacion  tipoComunicacionAux:tipoComunicacionList) {
			this.tipoComunicacionDao.remove(tipoComunicacionAux);
		}
	}


	/**
	 * Getter method for TipoComunicacionDao
	 *
	 * @return TipoComunicacionDao
	 */
	public TipoComunicacionDao getTipoComunicacionDao() {
		return this.tipoComunicacionDao;
	}
    
	/**
	 * Setter method for TipoComunicacionDao.
	 *
	 * @param  tipoComunicacionDao TipoComunicacionDao
	 * @return
	 */
	public void setTipoComunicacionDao(TipoComunicacionDao tipoComunicacionDao) {
		logger.info("Setting Dependency "+tipoComunicacionDao);
		this.tipoComunicacionDao = tipoComunicacionDao;
	}
}

