package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipmotActuacionDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipmotActuacion;

/**
 *  * TipmotActuacionServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "tipmotActuacionService")
public  class TipmotActuacionServiceImpl implements TipmotActuacionService {

	private static final  Logger logger = LoggerFactory.getLogger(TipmotActuacionServiceImpl.class);
	@Autowired
	private TipmotActuacionDao tipmotActuacionDao;

	/**
	 * Inserts a single row in the TipmotActuacion table.
	 *
	 * @param tipmotActuacion TipmotActuacion
	 * @return TipmotActuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipmotActuacion add(TipmotActuacion tipmotActuacion) {
		return this.tipmotActuacionDao.add(tipmotActuacion);
	}

	/**
	 * Updates a single row in the TipmotActuacion table.
	 *
	 * @param tipmotActuacion TipmotActuacion
	 * @return TipmotActuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipmotActuacion update(TipmotActuacion tipmotActuacion) {
		return this.tipmotActuacionDao.update(tipmotActuacion);
	 }

	/**
	 * Finds a single row in the TipmotActuacion table.
	 *
	 * @param tipmotActuacion TipmotActuacion
	 * @return TipmotActuacion
	 */
	public TipmotActuacion find(TipmotActuacion tipmotActuacion) {
		return (TipmotActuacion) this.tipmotActuacionDao.find(tipmotActuacion);
	}

	/**
	 * Finds a List of rows in the TipmotActuacion table.
	 *
	 * @param tipmotActuacion TipmotActuacion
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipmotActuacion> findAll(TipmotActuacion tipmotActuacion, Pagination pagination) {
		return (List<TipmotActuacion>) this.tipmotActuacionDao.findAll(tipmotActuacion, pagination);
	}
    
	/**
	 * Counts rows in the TipmotActuacion table.
	 *
	 * @param tipmotActuacion TipmotActuacion
	 * @return Long
	 */
	public Long findAllCount(TipmotActuacion tipmotActuacion) {        
		return  this.tipmotActuacionDao.findAllCount(tipmotActuacion);
	}

	/**
	 * Finds rows in the TipmotActuacion table using like.
	 *
	 * @param tipmotActuacion TipmotActuacion
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipmotActuacion> findAllLike(TipmotActuacion tipmotActuacion, Pagination pagination, Boolean startsWith) {
		return (List<TipmotActuacion>) this.tipmotActuacionDao.findAllLike(tipmotActuacion, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipmotActuacion table.
	 *
	 * @param tipmotActuacion TipmotActuacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipmotActuacion tipmotActuacion) {
		this.tipmotActuacionDao.remove(tipmotActuacion);
	}
	
	/**
	 * Deletes multiple rows in the TipmotActuacion table.
	 *
	 * @param tipmotActuacionList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipmotActuacion> tipmotActuacionList) {
		for (TipmotActuacion  tipmotActuacionAux:tipmotActuacionList) {
			this.tipmotActuacionDao.remove(tipmotActuacionAux);
		}
	}


	/**
	 * Getter method for TipmotActuacionDao
	 *
	 * @return TipmotActuacionDao
	 */
	public TipmotActuacionDao getTipmotActuacionDao() {
		return this.tipmotActuacionDao;
	}
    
	/**
	 * Setter method for TipmotActuacionDao.
	 *
	 * @param  tipmotActuacionDao TipmotActuacionDao
	 * @return
	 */
	public void setTipmotActuacionDao(TipmotActuacionDao tipmotActuacionDao) {
		logger.info("Setting Dependency "+tipmotActuacionDao);
		this.tipmotActuacionDao = tipmotActuacionDao;
	}
}

