package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipReqNormativoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipReqNormativo;

/**
 * * TipReqNormativoServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "tipReqNormativoService")
public class TipReqNormativoServiceImpl implements TipReqNormativoService {

	private static final Logger logger = LoggerFactory
			.getLogger(TipReqNormativoServiceImpl.class);
	@Autowired
	private TipReqNormativoDao tipReqNormativoDao;

	/**
	 * Inserts a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipReqNormativo add(TipReqNormativo tipReqNormativo) {
		return this.tipReqNormativoDao.add(tipReqNormativo);
	}

	/**
	 * Updates a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipReqNormativo update(TipReqNormativo tipReqNormativo) {
		return this.tipReqNormativoDao.update(tipReqNormativo);
	}

	/**
	 * Finds a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	public TipReqNormativo find(TipReqNormativo tipReqNormativo) {
		return (TipReqNormativo) this.tipReqNormativoDao.find(tipReqNormativo);
	}

	/**
	 * Finds a List of rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipReqNormativo> findAll(TipReqNormativo tipReqNormativo,
			Pagination pagination) {
		return (List<TipReqNormativo>) this.tipReqNormativoDao.findAll(
				tipReqNormativo, pagination);
	}

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return Long
	 */
	public Long findAllCount(TipReqNormativo tipReqNormativo) {
		return this.tipReqNormativoDao.findAllCount(tipReqNormativo);
	}

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipReqNormativo> findAllLike(TipReqNormativo tipReqNormativo,
			Pagination pagination, Boolean startsWith) {
		return (List<TipReqNormativo>) this.tipReqNormativoDao.findAllLike(
				tipReqNormativo, pagination, startsWith);
	}

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipReqNormativo> findAllLikeReqNormativo(
			TipReqNormativo tipReqNormativo, Pagination pagination,
			Boolean startsWith) {
		return (List<TipReqNormativo>) this.tipReqNormativoDao
				.findAllLikeReqNormativo(tipReqNormativo, pagination,
						startsWith);
	}

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeReqNormativoCount(TipReqNormativo tipReqNormativo,
			Boolean startsWith) {
		return this.tipReqNormativoDao.findAllLikeReqNormativoCount(
				tipReqNormativo, startsWith);
	}

	/**
	 * Deletes a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipReqNormativo tipReqNormativo) {
		this.tipReqNormativoDao.remove(tipReqNormativo);
	}

	/**
	 * Deletes multiple rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipReqNormativo> tipReqNormativoList) {
		for (TipReqNormativo tipReqNormativoAux : tipReqNormativoList) {
			this.tipReqNormativoDao.remove(tipReqNormativoAux);
		}
	}

	/**
	 * Getter method for TipReqNormativoDao
	 * 
	 * @return TipReqNormativoDao
	 */
	public TipReqNormativoDao getTipReqNormativoDao() {
		return this.tipReqNormativoDao;
	}

	/**
	 * Setter method for TipReqNormativoDao.
	 * 
	 * @param tipReqNormativoDao
	 *            TipReqNormativoDao
	 * @return
	 */
	public void setTipReqNormativoDao(TipReqNormativoDao tipReqNormativoDao) {
		logger.info("Setting Dependency " + tipReqNormativoDao);
		this.tipReqNormativoDao = tipReqNormativoDao;
	}
}
