package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipProtocoloDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipProtocolo;

/**
 *  * TipProtocoloServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "tipProtocoloService")
public  class TipProtocoloServiceImpl implements TipProtocoloService {

	private static final  Logger logger = LoggerFactory.getLogger(TipProtocoloServiceImpl.class);
	@Autowired
	private TipProtocoloDao tipProtocoloDao;

	/**
	 * Inserts a single row in the TipProtocolo table.
	 *
	 * @param tipProtocolo TipProtocolo
	 * @return TipProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipProtocolo add(TipProtocolo tipProtocolo) {
		return this.tipProtocoloDao.add(tipProtocolo);
	}

	/**
	 * Updates a single row in the TipProtocolo table.
	 *
	 * @param tipProtocolo TipProtocolo
	 * @return TipProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipProtocolo update(TipProtocolo tipProtocolo) {
		return this.tipProtocoloDao.update(tipProtocolo);
	 }

	/**
	 * Finds a single row in the TipProtocolo table.
	 *
	 * @param tipProtocolo TipProtocolo
	 * @return TipProtocolo
	 */
	public TipProtocolo find(TipProtocolo tipProtocolo) {
		return (TipProtocolo) this.tipProtocoloDao.find(tipProtocolo);
	}

	/**
	 * Finds a List of rows in the TipProtocolo table.
	 *
	 * @param tipProtocolo TipProtocolo
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipProtocolo> findAll(TipProtocolo tipProtocolo, Pagination pagination) {
		return (List<TipProtocolo>) this.tipProtocoloDao.findAll(tipProtocolo, pagination);
	}
    
	/**
	 * Counts rows in the TipProtocolo table.
	 *
	 * @param tipProtocolo TipProtocolo
	 * @return Long
	 */
	public Long findAllCount(TipProtocolo tipProtocolo) {        
		return  this.tipProtocoloDao.findAllCount(tipProtocolo);
	}

	/**
	 * Finds rows in the TipProtocolo table using like.
	 *
	 * @param tipProtocolo TipProtocolo
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipProtocolo> findAllLike(TipProtocolo tipProtocolo, Pagination pagination, Boolean startsWith) {
		return (List<TipProtocolo>) this.tipProtocoloDao.findAllLike(tipProtocolo, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipProtocolo table.
	 *
	 * @param tipProtocolo TipProtocolo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipProtocolo tipProtocolo) {
		this.tipProtocoloDao.remove(tipProtocolo);
	}
	
	/**
	 * Deletes multiple rows in the TipProtocolo table.
	 *
	 * @param tipProtocoloList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipProtocolo> tipProtocoloList) {
		for (TipProtocolo  tipProtocoloAux:tipProtocoloList) {
			this.tipProtocoloDao.remove(tipProtocoloAux);
		}
	}


	/**
	 * Getter method for TipProtocoloDao
	 *
	 * @return TipProtocoloDao
	 */
	public TipProtocoloDao getTipProtocoloDao() {
		return this.tipProtocoloDao;
	}
    
	/**
	 * Setter method for TipProtocoloDao.
	 *
	 * @param  tipProtocoloDao TipProtocoloDao
	 * @return
	 */
	public void setTipProtocoloDao(TipProtocoloDao tipProtocoloDao) {
		logger.info("Setting Dependency "+tipProtocoloDao);
		this.tipProtocoloDao = tipProtocoloDao;
	}
}

