package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipPregProtocDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipPregProtoc;

/**
 * * TipPregProtocServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "tipPregProtocService")
public class TipPregProtocServiceImpl implements TipPregProtocService {

	private static final Logger logger = LoggerFactory
			.getLogger(TipPregProtocServiceImpl.class);
	@Autowired
	private TipPregProtocDao tipPregProtocDao;

	/**
	 * Inserts a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipPregProtoc add(TipPregProtoc tipPregProtoc) {
		return this.tipPregProtocDao.add(tipPregProtoc);
	}

	/**
	 * Updates a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipPregProtoc update(TipPregProtoc tipPregProtoc) {
		return this.tipPregProtocDao.update(tipPregProtoc);
	}

	/**
	 * Finds a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	public TipPregProtoc find(TipPregProtoc tipPregProtoc) {
		return (TipPregProtoc) this.tipPregProtocDao.find(tipPregProtoc);
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipPregProtoc> findAll(TipPregProtoc tipPregProtoc,
			Pagination pagination) {
		return (List<TipPregProtoc>) this.tipPregProtocDao.findAll(
				tipPregProtoc, pagination);
	}

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return Long
	 */
	public Long findAllCount(TipPregProtoc tipPregProtoc) {
		return this.tipPregProtocDao.findAllCount(tipPregProtoc);
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipPregProtoc> findAllProtocoloOrdenado(
			TipPregProtoc tipPregProtoc) {
		return (List<TipPregProtoc>) this.tipPregProtocDao
				.findAllProtocoloOrdenado(tipPregProtoc);
	}

	/**
	 * Finds rows in the TipPregProtoc table using like.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipPregProtoc> findAllLike(TipPregProtoc tipPregProtoc,
			Pagination pagination, Boolean startsWith) {
		return (List<TipPregProtoc>) this.tipPregProtocDao.findAllLike(
				tipPregProtoc, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipPregProtoc tipPregProtoc) {
		this.tipPregProtocDao.remove(tipPregProtoc);
	}

	/**
	 * Deletes multiple rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtocList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipPregProtoc> tipPregProtocList) {
		for (TipPregProtoc tipPregProtocAux : tipPregProtocList) {
			this.tipPregProtocDao.remove(tipPregProtocAux);
		}
	}

	/**
	 * Getter method for TipPregProtocDao
	 * 
	 * @return TipPregProtocDao
	 */
	public TipPregProtocDao getTipPregProtocDao() {
		return this.tipPregProtocDao;
	}

	/**
	 * Setter method for TipPregProtocDao.
	 * 
	 * @param tipPregProtocDao
	 *            TipPregProtocDao
	 * @return
	 */
	public void setTipPregProtocDao(TipPregProtocDao tipPregProtocDao) {
		logger.info("Setting Dependency " + tipPregProtocDao);
		this.tipPregProtocDao = tipPregProtocDao;
	}
}
