package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipOrigenProdDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipOrigenProd;

/**
 *  * TipOrigenProdServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "tipOrigenProdService")
public  class TipOrigenProdServiceImpl implements TipOrigenProdService {

	private static final  Logger logger = LoggerFactory.getLogger(TipOrigenProdServiceImpl.class);
	@Autowired
	private TipOrigenProdDao tipOrigenProdDao;

	/**
	 * Inserts a single row in the TipOrigenProd table.
	 *
	 * @param tipOrigenProd TipOrigenProd
	 * @return TipOrigenProd
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipOrigenProd add(TipOrigenProd tipOrigenProd) {
		return this.tipOrigenProdDao.add(tipOrigenProd);
	}

	/**
	 * Updates a single row in the TipOrigenProd table.
	 *
	 * @param tipOrigenProd TipOrigenProd
	 * @return TipOrigenProd
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipOrigenProd update(TipOrigenProd tipOrigenProd) {
		return this.tipOrigenProdDao.update(tipOrigenProd);
	 }

	/**
	 * Finds a single row in the TipOrigenProd table.
	 *
	 * @param tipOrigenProd TipOrigenProd
	 * @return TipOrigenProd
	 */
	public TipOrigenProd find(TipOrigenProd tipOrigenProd) {
		return (TipOrigenProd) this.tipOrigenProdDao.find(tipOrigenProd);
	}

	/**
	 * Finds a List of rows in the TipOrigenProd table.
	 *
	 * @param tipOrigenProd TipOrigenProd
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipOrigenProd> findAll(TipOrigenProd tipOrigenProd, Pagination pagination) {
		return (List<TipOrigenProd>) this.tipOrigenProdDao.findAll(tipOrigenProd, pagination);
	}
    
	/**
	 * Counts rows in the TipOrigenProd table.
	 *
	 * @param tipOrigenProd TipOrigenProd
	 * @return Long
	 */
	public Long findAllCount(TipOrigenProd tipOrigenProd) {        
		return  this.tipOrigenProdDao.findAllCount(tipOrigenProd);
	}

	/**
	 * Finds rows in the TipOrigenProd table using like.
	 *
	 * @param tipOrigenProd TipOrigenProd
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipOrigenProd> findAllLike(TipOrigenProd tipOrigenProd, Pagination pagination, Boolean startsWith) {
		return (List<TipOrigenProd>) this.tipOrigenProdDao.findAllLike(tipOrigenProd, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipOrigenProd table.
	 *
	 * @param tipOrigenProd TipOrigenProd
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipOrigenProd tipOrigenProd) {
		this.tipOrigenProdDao.remove(tipOrigenProd);
	}
	
	/**
	 * Deletes multiple rows in the TipOrigenProd table.
	 *
	 * @param tipOrigenProdList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipOrigenProd> tipOrigenProdList) {
		for (TipOrigenProd  tipOrigenProdAux:tipOrigenProdList) {
			this.tipOrigenProdDao.remove(tipOrigenProdAux);
		}
	}


	/**
	 * Getter method for TipOrigenProdDao
	 *
	 * @return TipOrigenProdDao
	 */
	public TipOrigenProdDao getTipOrigenProdDao() {
		return this.tipOrigenProdDao;
	}
    
	/**
	 * Setter method for TipOrigenProdDao.
	 *
	 * @param  tipOrigenProdDao TipOrigenProdDao
	 * @return
	 */
	public void setTipOrigenProdDao(TipOrigenProdDao tipOrigenProdDao) {
		logger.info("Setting Dependency "+tipOrigenProdDao);
		this.tipOrigenProdDao = tipOrigenProdDao;
	}
}

