package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipDepoMuestraDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipDepoMuestra;

/**
 *  * TipDepoMuestraServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "tipDepoMuestraService")
public  class TipDepoMuestraServiceImpl implements TipDepoMuestraService {

	private static final  Logger logger = LoggerFactory.getLogger(TipDepoMuestraServiceImpl.class);
	@Autowired
	private TipDepoMuestraDao tipDepoMuestraDao;

	/**
	 * Inserts a single row in the TipDepoMuestra table.
	 *
	 * @param tipDepoMuestra TipDepoMuestra
	 * @return TipDepoMuestra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipDepoMuestra add(TipDepoMuestra tipDepoMuestra) {
		return this.tipDepoMuestraDao.add(tipDepoMuestra);
	}

	/**
	 * Updates a single row in the TipDepoMuestra table.
	 *
	 * @param tipDepoMuestra TipDepoMuestra
	 * @return TipDepoMuestra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipDepoMuestra update(TipDepoMuestra tipDepoMuestra) {
		return this.tipDepoMuestraDao.update(tipDepoMuestra);
	 }

	/**
	 * Finds a single row in the TipDepoMuestra table.
	 *
	 * @param tipDepoMuestra TipDepoMuestra
	 * @return TipDepoMuestra
	 */
	public TipDepoMuestra find(TipDepoMuestra tipDepoMuestra) {
		return (TipDepoMuestra) this.tipDepoMuestraDao.find(tipDepoMuestra);
	}

	/**
	 * Finds a List of rows in the TipDepoMuestra table.
	 *
	 * @param tipDepoMuestra TipDepoMuestra
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipDepoMuestra> findAll(TipDepoMuestra tipDepoMuestra, Pagination pagination) {
		return (List<TipDepoMuestra>) this.tipDepoMuestraDao.findAll(tipDepoMuestra, pagination);
	}
    
	/**
	 * Counts rows in the TipDepoMuestra table.
	 *
	 * @param tipDepoMuestra TipDepoMuestra
	 * @return Long
	 */
	public Long findAllCount(TipDepoMuestra tipDepoMuestra) {        
		return  this.tipDepoMuestraDao.findAllCount(tipDepoMuestra);
	}

	/**
	 * Finds rows in the TipDepoMuestra table using like.
	 *
	 * @param tipDepoMuestra TipDepoMuestra
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipDepoMuestra> findAllLike(TipDepoMuestra tipDepoMuestra, Pagination pagination, Boolean startsWith) {
		return (List<TipDepoMuestra>) this.tipDepoMuestraDao.findAllLike(tipDepoMuestra, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipDepoMuestra table.
	 *
	 * @param tipDepoMuestra TipDepoMuestra
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipDepoMuestra tipDepoMuestra) {
		this.tipDepoMuestraDao.remove(tipDepoMuestra);
	}
	
	/**
	 * Deletes multiple rows in the TipDepoMuestra table.
	 *
	 * @param tipDepoMuestraList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipDepoMuestra> tipDepoMuestraList) {
		for (TipDepoMuestra  tipDepoMuestraAux:tipDepoMuestraList) {
			this.tipDepoMuestraDao.remove(tipDepoMuestraAux);
		}
	}


	/**
	 * Getter method for TipDepoMuestraDao
	 *
	 * @return TipDepoMuestraDao
	 */
	public TipDepoMuestraDao getTipDepoMuestraDao() {
		return this.tipDepoMuestraDao;
	}
    
	/**
	 * Setter method for TipDepoMuestraDao.
	 *
	 * @param  tipDepoMuestraDao TipDepoMuestraDao
	 * @return
	 */
	public void setTipDepoMuestraDao(TipDepoMuestraDao tipDepoMuestraDao) {
		logger.info("Setting Dependency "+tipDepoMuestraDao);
		this.tipDepoMuestraDao = tipDepoMuestraDao;
	}
}

