package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipCaracMuestraDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipCaracMuestra;

/**
 *  * TipCaracMuestraServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "tipCaracMuestraService")
public  class TipCaracMuestraServiceImpl implements TipCaracMuestraService {

	private static final  Logger logger = LoggerFactory.getLogger(TipCaracMuestraServiceImpl.class);
	@Autowired
	private TipCaracMuestraDao tipCaracMuestraDao;

	/**
	 * Inserts a single row in the TipCaracMuestra table.
	 *
	 * @param tipCaracMuestra TipCaracMuestra
	 * @return TipCaracMuestra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipCaracMuestra add(TipCaracMuestra tipCaracMuestra) {
		return this.tipCaracMuestraDao.add(tipCaracMuestra);
	}

	/**
	 * Updates a single row in the TipCaracMuestra table.
	 *
	 * @param tipCaracMuestra TipCaracMuestra
	 * @return TipCaracMuestra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipCaracMuestra update(TipCaracMuestra tipCaracMuestra) {
		return this.tipCaracMuestraDao.update(tipCaracMuestra);
	 }

	/**
	 * Finds a single row in the TipCaracMuestra table.
	 *
	 * @param tipCaracMuestra TipCaracMuestra
	 * @return TipCaracMuestra
	 */
	public TipCaracMuestra find(TipCaracMuestra tipCaracMuestra) {
		return (TipCaracMuestra) this.tipCaracMuestraDao.find(tipCaracMuestra);
	}

	/**
	 * Finds a List of rows in the TipCaracMuestra table.
	 *
	 * @param tipCaracMuestra TipCaracMuestra
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipCaracMuestra> findAll(TipCaracMuestra tipCaracMuestra, Pagination pagination) {
		return (List<TipCaracMuestra>) this.tipCaracMuestraDao.findAll(tipCaracMuestra, pagination);
	}
    
	/**
	 * Counts rows in the TipCaracMuestra table.
	 *
	 * @param tipCaracMuestra TipCaracMuestra
	 * @return Long
	 */
	public Long findAllCount(TipCaracMuestra tipCaracMuestra) {        
		return  this.tipCaracMuestraDao.findAllCount(tipCaracMuestra);
	}

	/**
	 * Finds rows in the TipCaracMuestra table using like.
	 *
	 * @param tipCaracMuestra TipCaracMuestra
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipCaracMuestra> findAllLike(TipCaracMuestra tipCaracMuestra, Pagination pagination, Boolean startsWith) {
		return (List<TipCaracMuestra>) this.tipCaracMuestraDao.findAllLike(tipCaracMuestra, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipCaracMuestra table.
	 *
	 * @param tipCaracMuestra TipCaracMuestra
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipCaracMuestra tipCaracMuestra) {
		this.tipCaracMuestraDao.remove(tipCaracMuestra);
	}
	
	/**
	 * Deletes multiple rows in the TipCaracMuestra table.
	 *
	 * @param tipCaracMuestraList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipCaracMuestra> tipCaracMuestraList) {
		for (TipCaracMuestra  tipCaracMuestraAux:tipCaracMuestraList) {
			this.tipCaracMuestraDao.remove(tipCaracMuestraAux);
		}
	}


	/**
	 * Getter method for TipCaracMuestraDao
	 *
	 * @return TipCaracMuestraDao
	 */
	public TipCaracMuestraDao getTipCaracMuestraDao() {
		return this.tipCaracMuestraDao;
	}
    
	/**
	 * Setter method for TipCaracMuestraDao.
	 *
	 * @param  tipCaracMuestraDao TipCaracMuestraDao
	 * @return
	 */
	public void setTipCaracMuestraDao(TipCaracMuestraDao tipCaracMuestraDao) {
		logger.info("Setting Dependency "+tipCaracMuestraDao);
		this.tipCaracMuestraDao = tipCaracMuestraDao;
	}
}

