package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipAlertaDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipAlerta;

/**
 *  * TipAlertaServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "tipAlertaService")
public  class TipAlertaServiceImpl implements TipAlertaService {

	private static final  Logger logger = LoggerFactory.getLogger(TipAlertaServiceImpl.class);
	@Autowired
	private TipAlertaDao tipAlertaDao;

	/**
	 * Inserts a single row in the TipAlerta table.
	 *
	 * @param tipAlerta TipAlerta
	 * @return TipAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipAlerta add(TipAlerta tipAlerta) {
		return this.tipAlertaDao.add(tipAlerta);
	}

	/**
	 * Updates a single row in the TipAlerta table.
	 *
	 * @param tipAlerta TipAlerta
	 * @return TipAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipAlerta update(TipAlerta tipAlerta) {
		return this.tipAlertaDao.update(tipAlerta);
	 }

	/**
	 * Finds a single row in the TipAlerta table.
	 *
	 * @param tipAlerta TipAlerta
	 * @return TipAlerta
	 */
	public TipAlerta find(TipAlerta tipAlerta) {
		return (TipAlerta) this.tipAlertaDao.find(tipAlerta);
	}

	/**
	 * Finds a List of rows in the TipAlerta table.
	 *
	 * @param tipAlerta TipAlerta
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipAlerta> findAll(TipAlerta tipAlerta, Pagination pagination) {
		return (List<TipAlerta>) this.tipAlertaDao.findAll(tipAlerta, pagination);
	}
    
	/**
	 * Counts rows in the TipAlerta table.
	 *
	 * @param tipAlerta TipAlerta
	 * @return Long
	 */
	public Long findAllCount(TipAlerta tipAlerta) {        
		return  this.tipAlertaDao.findAllCount(tipAlerta);
	}

	/**
	 * Finds rows in the TipAlerta table using like.
	 *
	 * @param tipAlerta TipAlerta
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipAlerta> findAllLike(TipAlerta tipAlerta, Pagination pagination, Boolean startsWith) {
		return (List<TipAlerta>) this.tipAlertaDao.findAllLike(tipAlerta, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipAlerta table.
	 *
	 * @param tipAlerta TipAlerta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipAlerta tipAlerta) {
		this.tipAlertaDao.remove(tipAlerta);
	}
	
	/**
	 * Deletes multiple rows in the TipAlerta table.
	 *
	 * @param tipAlertaList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipAlerta> tipAlertaList) {
		for (TipAlerta  tipAlertaAux:tipAlertaList) {
			this.tipAlertaDao.remove(tipAlertaAux);
		}
	}


	/**
	 * Getter method for TipAlertaDao
	 *
	 * @return TipAlertaDao
	 */
	public TipAlertaDao getTipAlertaDao() {
		return this.tipAlertaDao;
	}
    
	/**
	 * Setter method for TipAlertaDao.
	 *
	 * @param  tipAlertaDao TipAlertaDao
	 * @return
	 */
	public void setTipAlertaDao(TipAlertaDao tipAlertaDao) {
		logger.info("Setting Dependency "+tipAlertaDao);
		this.tipAlertaDao = tipAlertaDao;
	}
}

