package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.TipActuacionDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.TipActuacion;

/**
 *  * TipActuacionServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 *  
 */

@Service(value = "tipActuacionService")
public  class TipActuacionServiceImpl implements TipActuacionService {

	private static final  Logger logger = LoggerFactory.getLogger(TipActuacionServiceImpl.class);
	@Autowired
	private TipActuacionDao tipActuacionDao;

	/**
	 * Inserts a single row in the TipActuacion table.
	 *
	 * @param tipActuacion TipActuacion
	 * @return TipActuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipActuacion add(TipActuacion tipActuacion) {
		return this.tipActuacionDao.add(tipActuacion);
	}

	/**
	 * Updates a single row in the TipActuacion table.
	 *
	 * @param tipActuacion TipActuacion
	 * @return TipActuacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipActuacion update(TipActuacion tipActuacion) {
		return this.tipActuacionDao.update(tipActuacion);
	 }

	/**
	 * Finds a single row in the TipActuacion table.
	 *
	 * @param tipActuacion TipActuacion
	 * @return TipActuacion
	 */
	public TipActuacion find(TipActuacion tipActuacion) {
		return (TipActuacion) this.tipActuacionDao.find(tipActuacion);
	}

	/**
	 * Finds a List of rows in the TipActuacion table.
	 *
	 * @param tipActuacion TipActuacion
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipActuacion> findAll(TipActuacion tipActuacion, Pagination pagination) {
		return (List<TipActuacion>) this.tipActuacionDao.findAll(tipActuacion, pagination);
	}
    
	/**
	 * Counts rows in the TipActuacion table.
	 *
	 * @param tipActuacion TipActuacion
	 * @return Long
	 */
	public Long findAllCount(TipActuacion tipActuacion) {        
		return  this.tipActuacionDao.findAllCount(tipActuacion);
	}

	/**
	 * Finds rows in the TipActuacion table using like.
	 *
	 * @param tipActuacion TipActuacion
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipActuacion> findAllLike(TipActuacion tipActuacion, Pagination pagination, Boolean startsWith) {
		return (List<TipActuacion>) this.tipActuacionDao.findAllLike(tipActuacion, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the TipActuacion table.
	 *
	 * @param tipActuacion TipActuacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipActuacion tipActuacion) {
		this.tipActuacionDao.remove(tipActuacion);
	}
	
	/**
	 * Deletes multiple rows in the TipActuacion table.
	 *
	 * @param tipActuacionList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipActuacion> tipActuacionList) {
		for (TipActuacion  tipActuacionAux:tipActuacionList) {
			this.tipActuacionDao.remove(tipActuacionAux);
		}
	}


	/**
	 * Getter method for TipActuacionDao
	 *
	 * @return TipActuacionDao
	 */
	public TipActuacionDao getTipActuacionDao() {
		return this.tipActuacionDao;
	}
    
	/**
	 * Setter method for TipActuacionDao.
	 *
	 * @param  tipActuacionDao TipActuacionDao
	 * @return
	 */
	public void setTipActuacionDao(TipActuacionDao tipActuacionDao) {
		logger.info("Setting Dependency "+tipActuacionDao);
		this.tipActuacionDao = tipActuacionDao;
	}
}

