package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.T17PaisDao;
import com.ejie.y41a.model.T17Pais;

/**
 * T17PaisServiceImpl generated by UDA 1.0, 15-jul-2011 8:38:37.
 * 
 *  
 */
@Service(value = "t17PaisService")
public class T17PaisServiceImpl implements T17PaisService {
	/**
	 * Final static logger.
	 */
	private static final Logger logger = LoggerFactory
			.getLogger(T17PaisServiceImpl.class);

	@Autowired
	private T17PaisDao t17PaisDao;

	/**
	 * Inserts a single row in the T17Pais table.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 * @return T17Pais
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Pais add(T17Pais t17Pais) {
		return this.t17PaisDao.add(t17Pais);
	}

	/**
	 * Updates a single row in the T17Pais table.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 * @return T17Pais
	 */
	@Transactional(rollbackFor = Throwable.class)
	public T17Pais update(T17Pais t17Pais) {
		return this.t17PaisDao.update(t17Pais);
	}

	/**
	 * Finds a single row in the T17Pais table.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 * @return T17Pais
	 */
	public T17Pais find(T17Pais t17Pais) {
		return (T17Pais) this.t17PaisDao.find(t17Pais);
	}

	/**
	 * Finds a List of rows in the T17Pais table.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Pais> findAll(T17Pais t17Pais, Pagination pagination) {
		return (List<T17Pais>) this.t17PaisDao.findAll(t17Pais, pagination);

	}

	/**
	 * Counts rows in the T17Pais table.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 * @return Long
	 */
	public Long findAllCount(T17Pais t17Pais) {
		return this.t17PaisDao.findAllCount(t17Pais);
	}

	/**
	 * Finds rows in the T17Pais table using like.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<T17Pais> findAllLike(T17Pais t17Pais, Pagination pagination,
			Boolean startsWith) {
		return (List<T17Pais>) this.t17PaisDao.findAllLike(t17Pais, pagination,
				startsWith);
	}

	/**
	 * Deletes a single row in the T17Pais table.
	 * 
	 * @param t17Pais
	 *            T17Pais
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(T17Pais t17Pais) {
		this.t17PaisDao.remove(t17Pais);
	}

	/**
	 * Deletes multiple rows in the T17Pais table.
	 * 
	 * @param t17PaisList
	 *            ArrayList
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<T17Pais> t17PaisList) {
		for (T17Pais t17PaisAux : t17PaisList) {
			this.t17PaisDao.remove(t17PaisAux);
		}
	}

	/**
	 * 
	 * @return T17PaisDao
	 */
	public T17PaisDao getT17PaisDao() {
		return this.t17PaisDao;
	}

	/**
	 * 
	 * @param t17PaisDao
	 *            T17PaisDao
	 */
	public void setT17PaisDao(T17PaisDao t17PaisDao) {
		logger.info("Setting Dependency " + t17PaisDao);
		this.t17PaisDao = t17PaisDao;
	}
}
