package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.SolicitudArbitrajeDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.SolicitudArbitraje;

/**
 *  * SolicitudArbitrajeServiceImpl generated by UDA, 22-feb-2012 17:30:29.
 *  
 */

@Service(value = "solicitudArbitrajeService")
public  class SolicitudArbitrajeServiceImpl implements SolicitudArbitrajeService {

	private static final  Logger logger = LoggerFactory.getLogger(SolicitudArbitrajeServiceImpl.class);
	@Autowired
	private SolicitudArbitrajeDao solicitudArbitrajeDao;

	/**
	 * Inserts a single row in the SolicitudArbitraje table.
	 *
	 * @param solicitudArbitraje SolicitudArbitraje
	 * @return SolicitudArbitraje
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudArbitraje add(SolicitudArbitraje solicitudArbitraje) {
		return this.solicitudArbitrajeDao.add(solicitudArbitraje);
	}

	/**
	 * Updates a single row in the SolicitudArbitraje table.
	 *
	 * @param solicitudArbitraje SolicitudArbitraje
	 * @return SolicitudArbitraje
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SolicitudArbitraje update(SolicitudArbitraje solicitudArbitraje) {
		return this.solicitudArbitrajeDao.update(solicitudArbitraje);
	 }

	/**
	 * Finds a single row in the SolicitudArbitraje table.
	 *
	 * @param solicitudArbitraje SolicitudArbitraje
	 * @return SolicitudArbitraje
	 */
	public SolicitudArbitraje find(SolicitudArbitraje solicitudArbitraje) {
		return (SolicitudArbitraje) this.solicitudArbitrajeDao.find(solicitudArbitraje);
	}

	/**
	 * Finds a List of rows in the SolicitudArbitraje table.
	 *
	 * @param solicitudArbitraje SolicitudArbitraje
	 * @param pagination Pagination
	 * @return List
	 */
	public List<SolicitudArbitraje> findAll(SolicitudArbitraje solicitudArbitraje, Pagination pagination) {
		return (List<SolicitudArbitraje>) this.solicitudArbitrajeDao.findAll(solicitudArbitraje, pagination);
	}
    
	/**
	 * Counts rows in the SolicitudArbitraje table.
	 *
	 * @param solicitudArbitraje SolicitudArbitraje
	 * @return Long
	 */
	public Long findAllCount(SolicitudArbitraje solicitudArbitraje) {        
		return  this.solicitudArbitrajeDao.findAllCount(solicitudArbitraje);
	}

	/**
	 * Finds rows in the SolicitudArbitraje table using like.
	 *
	 * @param solicitudArbitraje SolicitudArbitraje
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<SolicitudArbitraje> findAllLike(SolicitudArbitraje solicitudArbitraje, Pagination pagination, Boolean startsWith) {
		return (List<SolicitudArbitraje>) this.solicitudArbitrajeDao.findAllLike(solicitudArbitraje, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the SolicitudArbitraje table.
	 *
	 * @param solicitudArbitraje SolicitudArbitraje
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(SolicitudArbitraje solicitudArbitraje) {
		this.solicitudArbitrajeDao.remove(solicitudArbitraje);
	}
	
	/**
	 * Deletes multiple rows in the SolicitudArbitraje table.
	 *
	 * @param solicitudArbitrajeList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<SolicitudArbitraje> solicitudArbitrajeList) {
		for (SolicitudArbitraje  solicitudArbitrajeAux:solicitudArbitrajeList) {
			this.solicitudArbitrajeDao.remove(solicitudArbitrajeAux);
		}
	}


	/**
	 * Getter method for SolicitudArbitrajeDao
	 *
	 * @return SolicitudArbitrajeDao
	 */
	public SolicitudArbitrajeDao getSolicitudArbitrajeDao() {
		return this.solicitudArbitrajeDao;
	}
    
	/**
	 * Setter method for SolicitudArbitrajeDao.
	 *
	 * @param  solicitudArbitrajeDao SolicitudArbitrajeDao
	 * @return
	 */
	public void setSolicitudArbitrajeDao(SolicitudArbitrajeDao solicitudArbitrajeDao) {
		logger.info("Setting Dependency "+solicitudArbitrajeDao);
		this.solicitudArbitrajeDao = solicitudArbitrajeDao;
	}
}

