package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.SectorDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Sector;

/**
 * * SectorServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

@Service(value = "sectorService")
public class SectorServiceImpl implements SectorService {

	private static final Logger logger = LoggerFactory
			.getLogger(SectorServiceImpl.class);
	@Autowired
	private SectorDao sectorDao;

	/**
	 * Inserts a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sector add(Sector sector) {
		return this.sectorDao.add(sector);
	}

	/**
	 * Updates a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Sector update(Sector sector) {
		return this.sectorDao.update(sector);
	}

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	public Sector find(Sector sector) {
		return (Sector) this.sectorDao.find(sector);
	}

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	public Sector findSectorSeleccionable(Sector sector) {
		return (Sector) this.sectorDao.findSectorSeleccionable(sector);
	}

	/**
	 * Finds a List of rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Sector> findAll(Sector sector, Pagination pagination) {
		return (List<Sector>) this.sectorDao.findAll(sector, pagination);
	}

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Long
	 */
	public Long findAllCount(Sector sector) {
		return this.sectorDao.findAllCount(sector);
	}

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sector> findAllLike(Sector sector, Pagination pagination,
			Boolean startsWith) {
		return (List<Sector>) this.sectorDao.findAllLike(sector, pagination,
				startsWith);
	}

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Sector> findAllLikeSector(Sector sector, Pagination pagination,
			Boolean startsWith) {
		return (List<Sector>) this.sectorDao.findAllLikeSector(sector,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeSectorCount(Sector sector, Boolean startsWith) {
		return this.sectorDao.findAllLikeSectorCount(sector, startsWith);
	}

	/**
	 * Deletes a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Sector sector) {
		this.sectorDao.remove(sector);
	}

	/**
	 * Deletes multiple rows in the Sector table.
	 * 
	 * @param sectorList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Sector> sectorList) {
		for (Sector sectorAux : sectorList) {
			this.sectorDao.remove(sectorAux);
		}
	}

	/**
	 * Getter method for SectorDao
	 * 
	 * @return SectorDao
	 */
	public SectorDao getSectorDao() {
		return this.sectorDao;
	}

	/**
	 * Setter method for SectorDao.
	 * 
	 * @param sectorDao
	 *            SectorDao
	 * @return
	 */
	public void setSectorDao(SectorDao sectorDao) {
		logger.info("Setting Dependency " + sectorDao);
		this.sectorDao = sectorDao;
	}
}
