package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41a.model.Sector;

/**
 * * SectorService generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

public interface SectorService {

	/**
	 * Inserts a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	Sector add(Sector sector);

	/**
	 * Updates a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	Sector update(Sector sector);

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	Sector find(Sector sector);

	/**
	 * Finds a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	Sector findSectorSeleccionable(Sector sector);

	/**
	 * Finds a List of rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Sector> findAll(Sector sector, Pagination pagination);

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return Long
	 */
	Long findAllCount(Sector sector);

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sector> findAllLike(Sector sector, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Sector table using like.
	 * 
	 * @param sector
	 *            Sector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Sector> findAllLikeSector(Sector sector, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeSectorCount(Sector sector, Boolean startsWith);

	/**
	 * Deletes a single row in the Sector table.
	 * 
	 * @param sector
	 *            Sector
	 * @return
	 */
	void remove(Sector sector);

	/**
	 * Deletes multiple rows in the Sector table.
	 * 
	 * @param sectorList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Sector> sectorList);

}
