package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.SectorAgrupadoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.SectorAgrupado;

/**
 *  * SectorAgrupadoServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 *  
 */

@Service(value = "sectorAgrupadoService")
public  class SectorAgrupadoServiceImpl implements SectorAgrupadoService {

	private static final  Logger logger = LoggerFactory.getLogger(SectorAgrupadoServiceImpl.class);
	@Autowired
	private SectorAgrupadoDao sectorAgrupadoDao;

	/**
	 * Inserts a single row in the SectorAgrupado table.
	 *
	 * @param sectorAgrupado SectorAgrupado
	 * @return SectorAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SectorAgrupado add(SectorAgrupado sectorAgrupado) {
		return this.sectorAgrupadoDao.add(sectorAgrupado);
	}

	/**
	 * Updates a single row in the SectorAgrupado table.
	 *
	 * @param sectorAgrupado SectorAgrupado
	 * @return SectorAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public SectorAgrupado update(SectorAgrupado sectorAgrupado) {
		return this.sectorAgrupadoDao.update(sectorAgrupado);
	 }

	/**
	 * Finds a single row in the SectorAgrupado table.
	 *
	 * @param sectorAgrupado SectorAgrupado
	 * @return SectorAgrupado
	 */
	public SectorAgrupado find(SectorAgrupado sectorAgrupado) {
		return (SectorAgrupado) this.sectorAgrupadoDao.find(sectorAgrupado);
	}

	/**
	 * Finds a List of rows in the SectorAgrupado table.
	 *
	 * @param sectorAgrupado SectorAgrupado
	 * @param pagination Pagination
	 * @return List
	 */
	public List<SectorAgrupado> findAll(SectorAgrupado sectorAgrupado, Pagination pagination) {
		return (List<SectorAgrupado>) this.sectorAgrupadoDao.findAll(sectorAgrupado, pagination);
	}
    
	/**
	 * Counts rows in the SectorAgrupado table.
	 *
	 * @param sectorAgrupado SectorAgrupado
	 * @return Long
	 */
	public Long findAllCount(SectorAgrupado sectorAgrupado) {        
		return  this.sectorAgrupadoDao.findAllCount(sectorAgrupado);
	}

	/**
	 * Finds rows in the SectorAgrupado table using like.
	 *
	 * @param sectorAgrupado SectorAgrupado
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<SectorAgrupado> findAllLike(SectorAgrupado sectorAgrupado, Pagination pagination, Boolean startsWith) {
		return (List<SectorAgrupado>) this.sectorAgrupadoDao.findAllLike(sectorAgrupado, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the SectorAgrupado table.
	 *
	 * @param sectorAgrupado SectorAgrupado
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(SectorAgrupado sectorAgrupado) {
		this.sectorAgrupadoDao.remove(sectorAgrupado);
	}
	
	/**
	 * Deletes multiple rows in the SectorAgrupado table.
	 *
	 * @param sectorAgrupadoList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<SectorAgrupado> sectorAgrupadoList) {
		for (SectorAgrupado  sectorAgrupadoAux:sectorAgrupadoList) {
			this.sectorAgrupadoDao.remove(sectorAgrupadoAux);
		}
	}


	/**
	 * Getter method for SectorAgrupadoDao
	 *
	 * @return SectorAgrupadoDao
	 */
	public SectorAgrupadoDao getSectorAgrupadoDao() {
		return this.sectorAgrupadoDao;
	}
    
	/**
	 * Setter method for SectorAgrupadoDao.
	 *
	 * @param  sectorAgrupadoDao SectorAgrupadoDao
	 * @return
	 */
	public void setSectorAgrupadoDao(SectorAgrupadoDao sectorAgrupadoDao) {
		logger.info("Setting Dependency "+sectorAgrupadoDao);
		this.sectorAgrupadoDao = sectorAgrupadoDao;
	}
}

