package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.ActaInfraccionDao;
import com.ejie.y41a.dao.ActuacionDao;
import com.ejie.y41a.dao.CampahnaRecibDao;
import com.ejie.y41a.dao.ProtocoloDao;
import com.ejie.y41a.dao.TipPregProtocDao;
import com.ejie.y41a.model.ActaActuacionAlta;
import com.ejie.y41a.model.ActaInfraccion;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.CampahnaRecibBusqueda;
import com.ejie.y41a.model.Protocolo;
import com.ejie.y41a.model.ProtocoloDetalle;
import com.ejie.y41a.model.TipPregProtoc;
import com.ejie.y41a.model.TipProtocolo;
import com.ejie.y41a.model.TipReqNormativo;
import com.ejie.y41a.utils.Y41aUIDGenerator;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * ProtocoloServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "protocoloService")
public class ProtocoloServiceImpl implements ProtocoloService {

	private static final Logger logger = LoggerFactory
			.getLogger(ProtocoloServiceImpl.class);
	@Autowired
	private ProtocoloDao protocoloDao;
	@Autowired
	private ActaInfraccionDao actaInfraccionDao;
	@Autowired
	private TipPregProtocDao tipPregProtocDao;
	@Autowired
	private ActuacionDao actuacionDao;
	@Autowired
	private CampahnaRecibDao campahnaRecibDao;

	/**
	 * Inserts a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Protocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Protocolo add(Protocolo protocolo) {
		return this.protocoloDao.add(protocolo);
	}

	/**
	 * Updates a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Protocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Protocolo update(Protocolo protocolo) {
		return this.protocoloDao.update(protocolo);
	}

	/**
	 * Finds a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Protocolo
	 */
	public Protocolo find(Protocolo protocolo) {
		return (Protocolo) this.protocoloDao.find(protocolo);
	}

	/**
	 * Finds a List of rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Protocolo> findAll(Protocolo protocolo, Pagination pagination) {
		return (List<Protocolo>) this.protocoloDao.findAll(protocolo,
				pagination);
	}

	/**
	 * Finds a List of rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return List
	 */
	public List<ProtocoloDetalle> findAllProtocoloActuacionOrdenado(
			ProtocoloDetalle protocoloDetalle) {
		Protocolo protocolo = new Protocolo();
		TipPregProtoc tipPregProtoc = new TipPregProtoc();
		TipProtocolo tipProtocolo = new TipProtocolo();
		tipProtocolo.setTpcodigo(protocoloDetalle.getTpcodigo());
		tipPregProtoc.setTipProtocolo(tipProtocolo);
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(protocoloDetalle.getAtcodigo());
		protocolo.setActuacion(actuacion);
		protocolo.setTipPregProtoc(tipPregProtoc);

		if (protocoloDetalle.getAtcodigo() == null) {
			List<ProtocoloDetalle> listProtocoloDetalle = new ArrayList<ProtocoloDetalle>();
			List<TipPregProtoc> listTipPregProtoc = this.tipPregProtocDao
					.findAllProtocoloOrdenado(tipPregProtoc);

			for (TipPregProtoc tipPregPro : listTipPregProtoc) {
				listProtocoloDetalle.add(new ProtocoloDetalle(null, tipPregPro
						.getTrcodigo(), tipPregPro.getTrnrtipp(), tipPregPro
						.getTrcotipp(), tipPregPro.getTrdetipp(), tipPregPro
						.getTrinti(), tipPregPro.getTrinre(), tipPregPro
						.getTrrees(), tipPregPro.getTipProtocolo()
						.getTpcodigo(), null, null, null));
			}

			return listProtocoloDetalle;

		} else {
			List<ProtocoloDetalle> listProtocoloDetalle = new ArrayList<ProtocoloDetalle>();
			List<Protocolo> listProtocolo = this.protocoloDao
					.findAllProtocoloActuacionOrdenado(protocolo);

			for (Protocolo proto : listProtocolo) {
				listProtocoloDetalle.add(new ProtocoloDetalle(proto
						.getPtcodigo(), proto.getTipPregProtoc().getTrcodigo(),
						proto.getTipPregProtoc().getTrnrtipp(), proto
								.getTipPregProtoc().getTrcotipp(), proto
								.getTipPregProtoc().getTrdetipp(), proto
								.getTipPregProtoc().getTrinti(), proto
								.getTipPregProtoc().getTrinre(), proto
								.getTipPregProtoc().getTrrees(), proto
								.getTipPregProtoc().getTipProtocolo()
								.getTpcodigo(), proto.getActuacion()
								.getAtcodigo(), proto.getPtnrprtp(), proto
								.getPtcoretp()));
			}

			return listProtocoloDetalle;
		}
	}

	/**
	 * Updates a single row in the Protocolo table.
	 * 
	 * @param protocoloDetalleList
	 *            ArrayList
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void registerProtocolo(
			ArrayList<ProtocoloDetalle> protocoloDetalleList) {

		if (protocoloDetalleList != null && protocoloDetalleList.size() > 0) {

			ProtocoloDetalle protocoloDetalle = protocoloDetalleList.get(0);

			// Se elimina el protocolo de la actuacion
			this.protocoloDao.removeProtocoloActuacion(protocoloDetalle);

			// Se eliminan las infracciones de la actuacion
			this.actaInfraccionDao.removeInfraccionActa(protocoloDetalle);

			// Se inserta el protocolo nuevo
			for (ProtocoloDetalle protocoloDetalleAux : protocoloDetalleList) {
				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(protocoloDetalleAux.getAtcodigo());

				ActaActuacionAlta actaActuacionAlta = this.actuacionDao
						.findActuacion(actuacion);

				if (Y41aUtils.isFilled(actaActuacionAlta.getS4codigo())) {
					CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
					campahnaRecibBusqueda.setCodOrganismo(actaActuacionAlta
							.getAccoor());
					campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_CAMPAHNA);
					campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
							.getS4codigo());

					campahnaRecibBusqueda = this.campahnaRecibDao
							.findCampahnaRecib(campahnaRecibBusqueda);

					if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
						throw new Y41aUDAException(
								"error.campahna.CerradaException", true,
								new Exception());
					}
				} else if (Y41aUtils.isFilled(actaActuacionAlta.getS5codigo())) {
					CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
					campahnaRecibBusqueda.setCodOrganismo(actaActuacionAlta
							.getAccoor());
					campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_ALERTA);
					campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
							.getS5codigo());

					campahnaRecibBusqueda = this.campahnaRecibDao
							.findCampahnaRecib(campahnaRecibBusqueda);

					if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
						throw new Y41aUDAException(
								"error.alerta.CerradaException", true,
								new Exception());
					}
				} else if (Y41aUtils.isFilled(actaActuacionAlta.getS6codigo())) {
					CampahnaRecibBusqueda campahnaRecibBusqueda = new CampahnaRecibBusqueda();
					campahnaRecibBusqueda.setCodOrganismo(actaActuacionAlta
							.getAccoor());
					campahnaRecibBusqueda.setTipo(Y41aConstantes.TIPO_DENUNCIA);
					campahnaRecibBusqueda.setCodigoRecibida(actaActuacionAlta
							.getS6codigo());

					campahnaRecibBusqueda = this.campahnaRecibDao
							.findCampahnaRecib(campahnaRecibBusqueda);

					if (campahnaRecibBusqueda.getFecfinalizacion() != null) {
						throw new Y41aUDAException(
								"error.denuncia.CerradaException", true,
								new Exception());
					}
				}

				// Creamos el objeto protocolo
				// Generamos la pk
				protocoloDetalleAux.setPtcodigo(Y41aUIDGenerator.getInstance()
						.generateId(Y41aConstantes.PK_SIZE));

				// insertamos protocolo
				this.protocoloDao.add(new Protocolo(protocoloDetalleAux
						.getPtcodigo(), protocoloDetalleAux.getPtnrprtp(),
						protocoloDetalleAux.getPtcoretp(), new TipPregProtoc(
								protocoloDetalleAux.getTrcodigo(), null, null,
								null, null, null, null, new TipProtocolo(
										protocoloDetalleAux.getTpcodigo(),
										null, null, null), null),
						new Actuacion(protocoloDetalleAux.getAtcodigo(), null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null)));

				TipPregProtoc tippregprotoc = new TipPregProtoc();
				tippregprotoc.setTrcodigo(protocoloDetalleAux.getTrcodigo());

				// Se busca el tipo de pregunta
				tippregprotoc = this.tipPregProtocDao.find(tippregprotoc);

				// Se comprueba si no se ha contestado correctamente
				// se inserta la infraccion cometida
				if (tippregprotoc.getTrrees() != null
						&& !tippregprotoc.getTrrees().equals("-")
						&& protocoloDetalleAux.getPtcoretp() != null
						&& !protocoloDetalleAux.getPtcoretp().equals("")
						&& !tippregprotoc.getTrrees().equals(
								protocoloDetalleAux.getPtcoretp())) {

					if (tippregprotoc.getTipReqNormativo().getTticodigo() != null) {
						this.actaInfraccionDao.add(new ActaInfraccion(
								Y41aUIDGenerator.getInstance().generateId(
										Y41aConstantes.PK_SIZE),
								Y41aConstantes.VALOR_SI, new Actuacion(
										protocoloDetalleAux.getAtcodigo(),
										null, null, null, null, null, null,
										null, null, null, null, null, null,
										null, null, null, null, null, null,
										null, null, null), new TipReqNormativo(
										tippregprotoc.getTipReqNormativo()
												.getTticodigo(), null, null,
										null, null, null, null, null, null,
										null, null, null, null, null, null,
										null, null, null, null, null, null,
										null, null)));
					}
				}
			}

			// Se modifica el protocolo de la actuacion ATCOTP CODIGO DE TIPO
			// PROTOCOLO EN ACTUACION (FK A L2174T00)
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(protocoloDetalle.getAtcodigo());
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(protocoloDetalle.getTpcodigo());
			actuacion.setTipProtocolo(tipProtocolo);

			this.actuacionDao.updateTipoProtocoloActuacion(actuacion);
		}
	}

	/**
	 * Counts rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Long
	 */
	public Long findAllCount(Protocolo protocolo) {
		return this.protocoloDao.findAllCount(protocolo);
	}

	/**
	 * Finds rows in the Protocolo table using like.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Protocolo> findAllLike(Protocolo protocolo,
			Pagination pagination, Boolean startsWith) {
		return (List<Protocolo>) this.protocoloDao.findAllLike(protocolo,
				pagination, startsWith);
	}

	/**
	 * Deletes a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Protocolo protocolo) {
		this.protocoloDao.remove(protocolo);
	}

	/**
	 * Deletes multiple rows in the Protocolo table.
	 * 
	 * @param protocoloList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Protocolo> protocoloList) {
		for (Protocolo protocoloAux : protocoloList) {
			this.protocoloDao.remove(protocoloAux);
		}
	}

	/**
	 * Getter method for ProtocoloDao
	 * 
	 * @return ProtocoloDao
	 */
	public ProtocoloDao getProtocoloDao() {
		return this.protocoloDao;
	}

	/**
	 * Setter method for ProtocoloDao.
	 * 
	 * @param protocoloDao
	 *            ProtocoloDao
	 * @return
	 */
	public void setProtocoloDao(ProtocoloDao protocoloDao) {
		logger.info("Setting Dependency " + protocoloDao);
		this.protocoloDao = protocoloDao;
	}
}
