package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Protocolo;
import com.ejie.y41a.model.ProtocoloDetalle;

/**
 * * ProtocoloService generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

public interface ProtocoloService {

	/**
	 * Inserts a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Protocolo
	 */
	Protocolo add(Protocolo protocolo);

	/**
	 * Updates a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Protocolo
	 */
	Protocolo update(Protocolo protocolo);

	/**
	 * Finds a List of rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return List
	 */
	List<ProtocoloDetalle> findAllProtocoloActuacionOrdenado(
			ProtocoloDetalle protocoloDetalle);

	/**
	 * Updates a single row in the Protocolo table.
	 * 
	 * @param protocoloDetalleList
	 *            ArrayList
	 */
	void registerProtocolo(ArrayList<ProtocoloDetalle> protocoloDetalleList);

	/**
	 * Finds a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Protocolo
	 */
	Protocolo find(Protocolo protocolo);

	/**
	 * Finds a List of rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Protocolo> findAll(Protocolo protocolo, Pagination pagination);

	/**
	 * Counts rows in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Long
	 */
	Long findAllCount(Protocolo protocolo);

	/**
	 * Finds rows in the Protocolo table using like.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Protocolo> findAllLike(Protocolo protocolo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Deletes a single row in the Protocolo table.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return
	 */
	void remove(Protocolo protocolo);

	/**
	 * Deletes multiple rows in the Protocolo table.
	 * 
	 * @param protocoloList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Protocolo> protocoloList);

}
