package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.ProductoDao;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Producto;

/**
 * * ProductoServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

@Service(value = "productoService")
public class ProductoServiceImpl implements ProductoService {

	private static final Logger logger = LoggerFactory
			.getLogger(ProductoServiceImpl.class);
	@Autowired
	private ProductoDao productoDao;

	/**
	 * Inserts a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Producto add(Producto producto) {
		return this.productoDao.add(producto);
	}

	/**
	 * Updates a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Producto update(Producto producto) {
		return this.productoDao.update(producto);
	}

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	public Producto find(Producto producto) {
		return (Producto) this.productoDao.find(producto);
	}

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	public Producto findProductoSeleccionable(Producto producto) {
		return (Producto) this.productoDao.findProductoSeleccionable(producto);
	}

	/**
	 * Finds a List of rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Producto> findAll(Producto producto, Pagination pagination) {
		return (List<Producto>) this.productoDao.findAll(producto, pagination);
	}

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Long
	 */
	public Long findAllCount(Producto producto) {
		return this.productoDao.findAllCount(producto);
	}

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Producto> findAllLike(Producto producto, Pagination pagination,
			Boolean startsWith) {
		return (List<Producto>) this.productoDao.findAllLike(producto,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Producto producto, Boolean startsWith) {
		return this.productoDao.findAllLikeCount(producto, startsWith);
	}

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Producto> findAllLikeProducto(Producto producto,
			Pagination pagination, Boolean startsWith) {
		return (List<Producto>) this.productoDao.findAllLikeProducto(producto,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeProductoCount(Producto producto, Boolean startsWith) {
		return this.productoDao.findAllLikeProductoCount(producto, startsWith);
	}

	/**
	 * Deletes a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Producto producto) {
		this.productoDao.remove(producto);
	}

	/**
	 * Deletes multiple rows in the Producto table.
	 * 
	 * @param productoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<Producto> productoList) {
		for (Producto productoAux : productoList) {
			this.productoDao.remove(productoAux);
		}
	}

	/**
	 * Getter method for ProductoDao
	 * 
	 * @return ProductoDao
	 */
	public ProductoDao getProductoDao() {
		return this.productoDao;
	}

	/**
	 * Setter method for ProductoDao.
	 * 
	 * @param productoDao
	 *            ProductoDao
	 * @return
	 */
	public void setProductoDao(ProductoDao productoDao) {
		logger.info("Setting Dependency " + productoDao);
		this.productoDao = productoDao;
	}
}
