package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41a.model.Producto;

/**
 * * ProductoService generated by UDA, 01-feb-2012 17:10:37.
 * 
 *  
 */

public interface ProductoService {

	/**
	 * Inserts a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto add(Producto producto);

	/**
	 * Updates a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto update(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto find(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto findProductoSeleccionable(Producto producto);

	/**
	 * Finds a List of rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Producto> findAll(Producto producto, Pagination pagination);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return Long
	 */
	Long findAllCount(Producto producto);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Producto> findAllLike(Producto producto, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Producto producto, Boolean startsWith);

	/**
	 * Finds rows in the Producto table using like.
	 * 
	 * @param producto
	 *            Producto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Producto> findAllLikeProducto(Producto producto,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeProductoCount(Producto producto, Boolean startsWith);

	/**
	 * Deletes a single row in the Producto table.
	 * 
	 * @param producto
	 *            Producto
	 * @return
	 */
	void remove(Producto producto);

	/**
	 * Deletes multiple rows in the Producto table.
	 * 
	 * @param productoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<Producto> productoList);

}
