package com.ejie.y41a.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.ProdAgrupadoDao;
import com.ejie.y41a.model.Motivo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.ProdAgrupado;

/**
 *  * ProdAgrupadoServiceImpl generated by UDA, 01-feb-2012 17:10:37.
 *  
 */

@Service(value = "prodAgrupadoService")
public  class ProdAgrupadoServiceImpl implements ProdAgrupadoService {

	private static final  Logger logger = LoggerFactory.getLogger(ProdAgrupadoServiceImpl.class);
	@Autowired
	private ProdAgrupadoDao prodAgrupadoDao;

	/**
	 * Inserts a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return ProdAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ProdAgrupado add(ProdAgrupado prodAgrupado) {
		return this.prodAgrupadoDao.add(prodAgrupado);
	}

	/**
	 * Updates a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return ProdAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ProdAgrupado update(ProdAgrupado prodAgrupado) {
		return this.prodAgrupadoDao.update(prodAgrupado);
	 }

	/**
	 * Finds a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return ProdAgrupado
	 */
	public ProdAgrupado find(ProdAgrupado prodAgrupado) {
		return (ProdAgrupado) this.prodAgrupadoDao.find(prodAgrupado);
	}

	/**
	 * Finds a List of rows in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @param pagination Pagination
	 * @return List
	 */
	public List<ProdAgrupado> findAll(ProdAgrupado prodAgrupado, Pagination pagination) {
		return (List<ProdAgrupado>) this.prodAgrupadoDao.findAll(prodAgrupado, pagination);
	}
    
	/**
	 * Counts rows in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return Long
	 */
	public Long findAllCount(ProdAgrupado prodAgrupado) {        
		return  this.prodAgrupadoDao.findAllCount(prodAgrupado);
	}

	/**
	 * Finds rows in the ProdAgrupado table using like.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<ProdAgrupado> findAllLike(ProdAgrupado prodAgrupado, Pagination pagination, Boolean startsWith) {
		return (List<ProdAgrupado>) this.prodAgrupadoDao.findAllLike(prodAgrupado, pagination, startsWith);
	}
    
	/**
	 * Deletes a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ProdAgrupado prodAgrupado) {
		this.prodAgrupadoDao.remove(prodAgrupado);
	}
	
	/**
	 * Deletes multiple rows in the ProdAgrupado table.
	 *
	 * @param prodAgrupadoList ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<ProdAgrupado> prodAgrupadoList) {
		for (ProdAgrupado  prodAgrupadoAux:prodAgrupadoList) {
			this.prodAgrupadoDao.remove(prodAgrupadoAux);
		}
	}


	/**
	 * Inserts a single row in the ProdMotivo table.
	 *
	 * @param prodAgrupado  ProdAgrupado
	 * @return ProdAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ProdAgrupado addProdMotivo (ProdAgrupado prodAgrupado) {
		return this.prodAgrupadoDao.addProdMotivo(prodAgrupado);
	}
    
	/**
	 * Deletes a single row in the ProdMotivo table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeProdMotivo(ProdAgrupado prodAgrupado) {
		this.prodAgrupadoDao.removeProdMotivo(prodAgrupado);
	}
    
	/**
	 * Find a single row in the findProdMotivo Many To Many relationship.
	 *
	 * @param prodagrupado ProdAgrupado
	 * @param  motivo Motivo
	 * @param pagination Pagination
	 * @return ProdAgrupado
	 */
	public ProdAgrupado findProdMotivo(ProdAgrupado prodAgrupado, Motivo  motivo, Pagination pagination) {
		return this.prodAgrupadoDao.findProdMotivo(prodAgrupado, motivo, pagination);
	}
    
	/**
	 * Counts rows in the ProdMotivo table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @param  motivo Motivo
	 * @return List
	 */
	public Long findProdMotivoCount(ProdAgrupado prodAgrupado, Motivo motivo) {
		return this.prodAgrupadoDao.findProdMotivoCount(prodAgrupado, motivo);
	}

	/**
	 * Getter method for ProdAgrupadoDao
	 *
	 * @return ProdAgrupadoDao
	 */
	public ProdAgrupadoDao getProdAgrupadoDao() {
		return this.prodAgrupadoDao;
	}
    
	/**
	 * Setter method for ProdAgrupadoDao.
	 *
	 * @param  prodAgrupadoDao ProdAgrupadoDao
	 * @return
	 */
	public void setProdAgrupadoDao(ProdAgrupadoDao prodAgrupadoDao) {
		logger.info("Setting Dependency "+prodAgrupadoDao);
		this.prodAgrupadoDao = prodAgrupadoDao;
	}
}

