package com.ejie.y41a.service;


import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Motivo;
import java.util.ArrayList;
import java.util.List;

import com.ejie.y41a.model.ProdAgrupado;

/**
 *  * ProdAgrupadoService generated by UDA, 01-feb-2012 17:10:37.
 *  
 */

public interface ProdAgrupadoService {

	/**
	 * Inserts a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return ProdAgrupado
	 */
    ProdAgrupado add(ProdAgrupado prodAgrupado);

	/**
	 * Updates a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return ProdAgrupado
	 */
	ProdAgrupado update(ProdAgrupado prodAgrupado);

	/**
	 * Finds a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return ProdAgrupado
	 */
	ProdAgrupado find(ProdAgrupado prodAgrupado);

	/**
	 * Finds a List of rows in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @param pagination Pagination
	 * @return List
	 */
	List<ProdAgrupado> findAll(ProdAgrupado prodAgrupado, Pagination pagination);

	/**
	 * Counts rows in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return Long
	 */
	Long findAllCount(ProdAgrupado prodAgrupado);
	
	/**
	 * Finds rows in the ProdAgrupado table using like.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<ProdAgrupado> findAllLike(ProdAgrupado prodAgrupado, Pagination pagination, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the ProdAgrupado table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 * @return 
	 */
	void remove(ProdAgrupado prodAgrupado);
	
	/**
	 * Deletes multiple rows in the ProdAgrupado table.
	 *
	 * @param prodAgrupadoList  ArrayList
	 * @return 
	 */	
	void removeMultiple(ArrayList<ProdAgrupado> prodAgrupadoList);
    

	/**
	 * Inserts a single row in the ProdMotivo table.
	 *
	 * @param prodAgrupado  ProdAgrupado
	 * @return ProdAgrupado 
	 */
	ProdAgrupado addProdMotivo(ProdAgrupado prodAgrupado);

	/**
	 * Deletes a single row in the ProdMotivo table.
	 *
	 * @param prodAgrupado ProdAgrupado
	 */
	void removeProdMotivo(ProdAgrupado prodAgrupado);

	/**
	 * Find a single row in the findProdMotivo Many To Many relationship.
	 *
	 * @param prodagrupado ProdAgrupado
	 * @param  motivo Motivo
	 * @param pagination Pagination
	 * @return ProdAgrupado
	 */
	ProdAgrupado findProdMotivo(ProdAgrupado prodagrupado, Motivo motivo, Pagination pagination);

	/**
	 * Counts rows in the ProdMotivo table.
	 * 
	 * @param prodAgrupado ProdAgrupado
	 * @param  motivo Motivo
	 * @return List
	 */
	Long findProdMotivoCount(ProdAgrupado prodagrupado, Motivo motivo) ;
}


