package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.dao.PlantillasFichasSolicitudesDao;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.FichasSolicitudes;
import com.ejie.y41a.model.PlantillasFichasSolicitudes;
import com.ejie.y41a.utils.documentos.Y41aDocumento;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * PlantillasFichasSolicitudesServiceImpl generated by UDA, 26-ene-2016
 * 17:53:34.
 * 
 *  
 */

@Service(value = "plantillasFichasSolicitudesService")
public class PlantillasFichasSolicitudesServiceImpl implements
		PlantillasFichasSolicitudesService {

	@Autowired
	private PlantillasFichasSolicitudesDao plantillasFichasSolicitudesDao;

	/**
	 * Inserts a single row in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @return PlantillasFichasSolicitudes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillasFichasSolicitudes add(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes) {
		return this.plantillasFichasSolicitudesDao
				.add(plantillasFichasSolicitudes);
	}

	/**
	 * Updates a single row in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @return PlantillasFichasSolicitudes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillasFichasSolicitudes update(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes) {
		return this.plantillasFichasSolicitudesDao
				.update(plantillasFichasSolicitudes);
	}

	/**
	 * Finds a single row in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @return PlantillasFichasSolicitudes
	 */
	public PlantillasFichasSolicitudes find(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes) {
		return (PlantillasFichasSolicitudes) this.plantillasFichasSolicitudesDao
				.find(plantillasFichasSolicitudes);
	}

	/**
	 * Finds a List of rows in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<PlantillasFichasSolicitudes> findAll(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes,
			Pagination pagination) {
		return (List<PlantillasFichasSolicitudes>) this.plantillasFichasSolicitudesDao
				.findAll(plantillasFichasSolicitudes, pagination);
	}

	/**
	 * Counts rows in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @return Long
	 */
	public Long findAllCount(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes) {
		return this.plantillasFichasSolicitudesDao
				.findAllCount(plantillasFichasSolicitudes);
	}

	/**
	 * Getter method for PlantillasFichasSolicitudesDao
	 * 
	 * @return PlantillasFichasSolicitudesDao
	 */
	public PlantillasFichasSolicitudesDao getPlantillasFichasSolicitudesDao() {
		return this.plantillasFichasSolicitudesDao;
	}

	/**
	 * Setter method for PlantillasFichasSolicitudesDao.
	 * 
	 * @param plantillasFichasSolicitudesDao
	 *            PlantillasFichasSolicitudesDao
	 * @return
	 */
	public void setPlantillasFichasSolicitudesDao(
			PlantillasFichasSolicitudesDao plantillasFichasSolicitudesDao) {
		this.plantillasFichasSolicitudesDao = plantillasFichasSolicitudesDao;
	}

	/**
	 * Obtiene la plantilla asociada a una ficha almacenando el fichero binario
	 * en una tabla temporal. El fichero de la tabla temporal se borra tras ser
	 * obtenido
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes filtro de plantilla que identifica
	 *            a una plantilla de manera unívoca
	 * @return plantillasFichasSolicitudes datos de plantillasFichasSolicitudes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillasFichasSolicitudes obtenerDocumentoPlantilla(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes) {
		plantillasFichasSolicitudes = (PlantillasFichasSolicitudes) this.plantillasFichasSolicitudesDao
				.find(plantillasFichasSolicitudes);

		return plantillasFichasSolicitudes;
	}

	/**
	 * Updates a single row in the PlantillaTramite table. Actualiza los datos
	 * de la plantilla con el nuevo documento
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes datos de la plantilla
	 * @return PlantillasFichasSolicitudes plantilla actualizada
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillasFichasSolicitudes updatePlantilla(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes) {
		return this.plantillasFichasSolicitudesDao
				.updatePlantilla(plantillasFichasSolicitudes);
	}

	/**
	 * Obtiene el fichero binario de una plantilla por ficha y organismo
	 * 
	 * @param ficodigo
	 *            código de ficha
	 * @param codOrg
	 *            código de organismo
	 * @return array de bytes
	 */
	public String obtieneBinarioPlantillaFichaByOrganismo(String ficodigo,
			String codOrg) {
		String result = null;
		PlantillasFichasSolicitudes filtroPlantillaSolicitudes = new PlantillasFichasSolicitudes();
		filtroPlantillaSolicitudes.setPfcoor(codOrg);
		FichasSolicitudes ficha = new FichasSolicitudes();
		ficha.setFicodigo(ficodigo);
		filtroPlantillaSolicitudes.setFichasSolicitudes(ficha);
		filtroPlantillaSolicitudes = this.findAll(filtroPlantillaSolicitudes,
				null).get(0);
		PlantillasFichasSolicitudes plantillaSolicitudes = this
				.obtenerDocumentoPlantilla(filtroPlantillaSolicitudes);

		byte[] contenidoPlantilla;
		try {
			contenidoPlantilla = Y41aDocumento
					.inputStreamToByteArray(plantillaSolicitudes
							.getPfplantilla().getBinaryStream());
		} catch (IOException e) {
			throw new Y41aUDAException(e.getMessage(), false, e);
		} catch (SQLException e) {
			throw new Y41aUDAException(e.getMessage(), false, e);
		}
		result = new String(contenidoPlantilla);
		return result;
	}
}
