package com.ejie.y41a.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41a.model.PlantillasFichasSolicitudes;

/**
 * * PlantillasFichasSolicitudesService generated by UDA, 26-ene-2016 17:53:34.
 * 
 *  
 */

public interface PlantillasFichasSolicitudesService {

	/**
	 * Updates a single row in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @return PlantillasFichasSolicitudes
	 */
	PlantillasFichasSolicitudes update(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes);

	/**
	 * Finds a single row in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @return PlantillasFichasSolicitudes
	 */
	PlantillasFichasSolicitudes find(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes);

	/**
	 * Finds a List of rows in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillasFichasSolicitudes> findAll(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes,
			Pagination pagination);

	/**
	 * Counts rows in the PlantillasFichasSolicitudes table.
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @return Long
	 */
	Long findAllCount(PlantillasFichasSolicitudes plantillasFichasSolicitudes);

	/**
	 * Obtiene la plantilla asociada a una ficha almacenando el fichero binario
	 * en una tabla temporal. El fichero de la tabla temporal se borra tras ser
	 * obtenido
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes filtro de plantilla que identifica
	 *            a una plantilla de manera unívoca
	 * @return PlantillasFichasSolicitudes datos de plantillasFichasSolicitudes
	 */
	PlantillasFichasSolicitudes obtenerDocumentoPlantilla(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes);

	/**
	 * Updates a single row in the PlantillaTramite table. Actualiza los datos
	 * de la plantilla con el nuevo documento
	 * 
	 * @param plantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes datos de la plantilla
	 * @return PlantillasFichasSolicitudes plantilla actualizada
	 */
	PlantillasFichasSolicitudes updatePlantilla(
			PlantillasFichasSolicitudes plantillasFichasSolicitudes);

	/**
	 * Obtiene el fichero binario de una plantilla por ficha y organismo
	 * 
	 * @param ficodigo
	 *            código de ficha
	 * @param codOrg
	 *            código de organismo
	 * @return array de bytes
	 */
	public String obtieneBinarioPlantillaFichaByOrganismo(String ficodigo,
			String codOrg);
}
