package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.PlantillaTramiteDao;
import com.ejie.y41a.model.PlantillaTramite;
import com.ejie.y41a.model.PlantillaTramiteBusqueda;

/**
 * * PlantillaTramiteServiceImpl generated by UDA, 05-mar-2012 9:11:43.
 * 
 *  
 */

@Service(value = "plantillaTramiteService")
public class PlantillaTramiteServiceImpl implements PlantillaTramiteService {

	private static final Logger logger = LoggerFactory
			.getLogger(PlantillaTramiteServiceImpl.class);
	@Autowired
	private PlantillaTramiteDao plantillaTramiteDao;

	/**
	 * Inserts a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaTramite add(PlantillaTramite plantillaTramite) {
		return this.plantillaTramiteDao.add(plantillaTramite);
	}

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaTramite update(PlantillaTramite plantillaTramite) {
		return this.plantillaTramiteDao.update(plantillaTramite);
	}

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaTramite updatePlantilla(PlantillaTramite plantillaTramite) {
		return this.plantillaTramiteDao.updatePlantilla(plantillaTramite);
	}

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaTramite updatePlantillaTodosOrganismos(
			PlantillaTramite plantillaTramite) {
		// buscar los diferentes codigos de organismo que tienen plantillas
		List<PlantillaTramite> listPlantillaTramite = this.plantillaTramiteDao
				.findAllOrganismos();

		for (PlantillaTramite planTramite : listPlantillaTramite) {
			plantillaTramite.setPtcoor(planTramite.getPtcoor());

			this.plantillaTramiteDao.updatePlantilla(plantillaTramite);
		}

		if (listPlantillaTramite.size() == 0) {
			plantillaTramite.setPtcoor(Y41aConstantes.CODIGO_ORGANISMO_LAKUA);

			this.plantillaTramiteDao.updatePlantilla(plantillaTramite);
		}

		return plantillaTramite;
	}

	/**
	 * Obtiene la plantilla del tramite
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaTramite obtenerDocumentoPlantilla(
			PlantillaTramite plantillaTramite) {
		plantillaTramite = (PlantillaTramite) this.plantillaTramiteDao
				.find(plantillaTramite);

		return plantillaTramite;
	}

	/**
	 * Finds a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	public PlantillaTramite find(PlantillaTramite plantillaTramite) {
		return (PlantillaTramite) this.plantillaTramiteDao
				.find(plantillaTramite);
	}

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<PlantillaTramite> findAll(PlantillaTramite plantillaTramite,
			Pagination pagination) {
		return (List<PlantillaTramite>) this.plantillaTramiteDao.findAll(
				plantillaTramite, pagination);
	}

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<PlantillaTramiteBusqueda> findAllPlantillaTramite(
			PlantillaTramite plantillaTramite, Pagination pagination) {
		List<PlantillaTramiteBusqueda> listPlantillaTramiteBusqueda = new ArrayList<PlantillaTramiteBusqueda>();
		List<PlantillaTramite> listPlantillaTramite = this.plantillaTramiteDao
				.findAllTramite(plantillaTramite, pagination);

		for (PlantillaTramite plantTramite : listPlantillaTramite) {

			listPlantillaTramiteBusqueda.add(new PlantillaTramiteBusqueda(
					plantTramite.getPtcodigo(), plantTramite.getTramite()
							.getTrcodigo(), plantTramite.getTramite()
							.getTrnombre(), plantTramite.getTramite()
							.getTrnombree(), plantTramite.getTramite()
							.getTrbaja(), plantTramite.getPtcoor(),
					plantTramite.getPtnombre(), plantTramite.getPtnombree(),
					plantTramite.getPtplantilla(), plantTramite
							.getPtplantillae(), plantTramite
							.getPtultmodificacion(), plantTramite
							.getPtcontenttypefile(),
					plantTramite.getPtnofile(), plantTramite.getPtsizefile(),
					plantTramite.getPtcontenttypefilee(), plantTramite
							.getPtnofilee(), plantTramite.getPtsizefilee()));
		}

		return listPlantillaTramiteBusqueda;
	}

	/**
	 * Counts rows in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return Long
	 */
	public Long findAllPlantillaTramiteCount(PlantillaTramite plantillaTramite) {
		return this.plantillaTramiteDao.findAllTramiteCount(plantillaTramite);
	}

	/**
	 * Counts rows in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return Long
	 */
	public Long findAllCount(PlantillaTramite plantillaTramite) {
		return this.plantillaTramiteDao.findAllCount(plantillaTramite);
	}

	/**
	 * Finds rows in the PlantillaTramite table using like.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<PlantillaTramite> findAllLike(
			PlantillaTramite plantillaTramite, Pagination pagination,
			Boolean startsWith) {
		return (List<PlantillaTramite>) this.plantillaTramiteDao.findAllLike(
				plantillaTramite, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(PlantillaTramite plantillaTramite) {
		this.plantillaTramiteDao.remove(plantillaTramite);
	}

	/**
	 * Deletes multiple rows in the PlantillaTramite table.
	 * 
	 * @param plantillaTramiteList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<PlantillaTramite> plantillaTramiteList) {
		for (PlantillaTramite plantillaTramiteAux : plantillaTramiteList) {
			this.plantillaTramiteDao.remove(plantillaTramiteAux);
		}
	}

	/**
	 * Getter method for PlantillaTramiteDao
	 * 
	 * @return PlantillaTramiteDao
	 */
	public PlantillaTramiteDao getPlantillaTramiteDao() {
		return this.plantillaTramiteDao;
	}

	/**
	 * Setter method for PlantillaTramiteDao.
	 * 
	 * @param plantillaTramiteDao
	 *            PlantillaTramiteDao
	 * @return
	 */
	public void setPlantillaTramiteDao(PlantillaTramiteDao plantillaTramiteDao) {
		logger.info("Setting Dependency " + plantillaTramiteDao);
		this.plantillaTramiteDao = plantillaTramiteDao;
	}
}
