package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.PlantillaTramite;
import com.ejie.y41a.model.PlantillaTramiteBusqueda;

/**
 * * PlantillaTramiteService generated by UDA, 05-mar-2012 9:11:43.
 * 
 *  
 */

public interface PlantillaTramiteService {

	/**
	 * Inserts a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	PlantillaTramite add(PlantillaTramite plantillaTramite);

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	PlantillaTramite update(PlantillaTramite plantillaTramite);

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	PlantillaTramite updatePlantilla(PlantillaTramite plantillaTramite);

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	PlantillaTramite updatePlantillaTodosOrganismos(
			PlantillaTramite plantillaTramite);

	/**
	 * Finds a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	PlantillaTramite find(PlantillaTramite plantillaTramite);

	/**
	 * Obtiene la plantilla del tramite
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	PlantillaTramite obtenerDocumentoPlantilla(PlantillaTramite plantillaTramite);

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaTramite> findAll(PlantillaTramite plantillaTramite,
			Pagination pagination);

	/**
	 * Counts rows in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return Long
	 */
	Long findAllCount(PlantillaTramite plantillaTramite);

	/**
	 * Finds rows in the PlantillaTramite table using like.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<PlantillaTramite> findAllLike(PlantillaTramite plantillaTramite,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaTramiteBusqueda> findAllPlantillaTramite(
			PlantillaTramite plantillaTramite, Pagination pagination);

	/**
	 * Counts rows in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return Long
	 */
	Long findAllPlantillaTramiteCount(PlantillaTramite plantillaTramite);

	/**
	 * Deletes a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return
	 */
	void remove(PlantillaTramite plantillaTramite);

	/**
	 * Deletes multiple rows in the PlantillaTramite table.
	 * 
	 * @param plantillaTramiteList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<PlantillaTramite> plantillaTramiteList);

}
