package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.dao.PlantillaInsDao;
import com.ejie.y41a.model.PlantillaIns;
import com.ejie.y41a.model.PlantillaInsBusqueda;

/**
 * * PlantillaInsServiceImpl generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

@Service(value = "plantillaInsService")
public class PlantillaInsServiceImpl implements PlantillaInsService {

	private static final Logger logger = LoggerFactory
			.getLogger(PlantillaInsServiceImpl.class);
	@Autowired
	private PlantillaInsDao plantillaInsDao;

	/**
	 * Inserts a single row in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaIns add(PlantillaIns plantillaIns) {
		return this.plantillaInsDao.add(plantillaIns);
	}

	/**
	 * Updates a single row in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaIns update(PlantillaIns plantillaIns) {
		return this.plantillaInsDao.update(plantillaIns);
	}

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaIns updatePlantilla(PlantillaIns plantillaIns) {
		return this.plantillaInsDao.updatePlantilla(plantillaIns);
	}

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaIns updatePlantillaTodosOrganismos(PlantillaIns plantillaIns) {
		// buscar los diferentes codigos de organismo que tienen plantillas
		List<PlantillaIns> listPlantillaIns = this.plantillaInsDao
				.findAllInspecciones();

		for (PlantillaIns plantIns : listPlantillaIns) {
			plantillaIns.setPlinscoor(plantIns.getPlinscoor());

			this.plantillaInsDao.updatePlantilla(plantillaIns);
		}

		if (listPlantillaIns.size() == 0) {
			plantillaIns.setPlinscoor(Y41aConstantes.CODIGO_ORGANISMO_LAKUA);

			this.plantillaInsDao.updatePlantilla(plantillaIns);
		}

		return plantillaIns;
	}

	/**
	 * Obtiene la plantilla de la inspeccion
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	@Transactional(rollbackFor = Throwable.class)
	public PlantillaIns obtenerDocumentoPlantilla(PlantillaIns plantillaIns) {
		plantillaIns = (PlantillaIns) this.plantillaInsDao.find(plantillaIns);

		return plantillaIns;
	}

	/**
	 * Finds a single row in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	public PlantillaIns find(PlantillaIns plantillaIns) {
		return (PlantillaIns) this.plantillaInsDao.find(plantillaIns);
	}

	/**
	 * Finds a List of rows in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<PlantillaIns> findAll(PlantillaIns plantillaIns,
			Pagination pagination) {
		return (List<PlantillaIns>) this.plantillaInsDao.findAll(plantillaIns,
				pagination);
	}

	/**
	 * Counts rows in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return Long
	 */
	public Long findAllCount(PlantillaIns plantillaIns) {
		return this.plantillaInsDao.findAllCount(plantillaIns);
	}

	/**
	 * Counts rows in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return Long
	 */
	public Long findAllCountInspeccion(PlantillaIns plantillaIns) {
		return this.plantillaInsDao.findAllCountInspeccion(plantillaIns);
	}

	/**
	 * Finds rows in the PlantillaIns table using like.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<PlantillaIns> findAllLike(PlantillaIns plantillaIns,
			Pagination pagination, Boolean startsWith) {
		return (List<PlantillaIns>) this.plantillaInsDao.findAllLike(
				plantillaIns, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(PlantillaIns plantillaIns) {
		this.plantillaInsDao.remove(plantillaIns);
	}

	/**
	 * Deletes multiple rows in the PlantillaIns table.
	 * 
	 * @param plantillaInsList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<PlantillaIns> plantillaInsList) {
		for (PlantillaIns plantillaInsAux : plantillaInsList) {
			this.plantillaInsDao.remove(plantillaInsAux);
		}
	}

	/**
	 * Getter method for PlantillaInsDao
	 * 
	 * @return PlantillaInsDao
	 */
	public PlantillaInsDao getPlantillaInsDao() {
		return this.plantillaInsDao;
	}

	/**
	 * Setter method for PlantillaInsDao.
	 * 
	 * @param plantillaInsDao
	 *            PlantillaInsDao
	 * @return
	 */
	public void setPlantillaInsDao(PlantillaInsDao plantillaInsDao) {
		logger.info("Setting Dependency " + plantillaInsDao);
		this.plantillaInsDao = plantillaInsDao;
	}

	/**
	 * Finds a List of rows in the PlantillaiNS table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<PlantillaInsBusqueda> findAllPlantillaIns(
			PlantillaIns plantillaIns, Pagination pagination) {
		List<PlantillaInsBusqueda> listPlantillaInsBusqueda = new ArrayList<PlantillaInsBusqueda>();
		List<PlantillaIns> listPlantillaIns = this.plantillaInsDao.findAllIns(
				plantillaIns, pagination);

		for (PlantillaIns plantIns : listPlantillaIns) {
			listPlantillaInsBusqueda.add(new PlantillaInsBusqueda(plantIns
					.getPlinscodigo(), plantIns.getPlinscoor(), plantIns
					.getPlinsnombre(), plantIns.getPlinsplantilla(), plantIns
					.getPlinscontenttypefile(), plantIns.getPlinsnofile(),
					plantIns.getPlinssizefile(), plantIns
							.getPlinsultmodificacion(), plantIns
							.getInspecciones().getInscodcarta(), plantIns
							.getInspecciones().getInsnombre(), plantIns
							.getInspecciones().getInsnombree(), plantIns
							.getInspecciones().getInsbaja()));
		}

		return listPlantillaInsBusqueda;
	}

}
