package com.ejie.y41a.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.PlantillaIns;
import com.ejie.y41a.model.PlantillaInsBusqueda;

/**
 * * PlantillaInsService generated by UDA, 22-mar-2012 16:48:08.
 * 
 *  
 */

public interface PlantillaInsService {

	/**
	 * Inserts a single row in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	PlantillaIns add(PlantillaIns plantillaIns);

	/**
	 * Updates a single row in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	PlantillaIns update(PlantillaIns plantillaIns);

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaTramite
	 *            PlantillaTramite
	 * @return PlantillaTramite
	 */
	PlantillaIns updatePlantilla(PlantillaIns plantillaIns);

	/**
	 * Updates a single row in the PlantillaTramite table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	PlantillaIns updatePlantillaTodosOrganismos(PlantillaIns plantillaIns);

	/**
	 * Obtiene la plantilla de la inspeccion
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	PlantillaIns obtenerDocumentoPlantilla(PlantillaIns plantillaIns);

	/**
	 * Finds a single row in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	PlantillaIns find(PlantillaIns plantillaIns);

	/**
	 * Finds a List of rows in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaIns> findAll(PlantillaIns plantillaIns, Pagination pagination);

	/**
	 * Finds a List of rows in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlantillaInsBusqueda> findAllPlantillaIns(PlantillaIns plantillaIns,
			Pagination pagination);

	/**
	 * Counts rows in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return Long
	 */
	Long findAllCount(PlantillaIns plantillaIns);

	/**
	 * Counts rows in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return Long
	 */
	Long findAllCountInspeccion(PlantillaIns plantillaIns);

	/**
	 * Finds rows in the PlantillaIns table using like.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<PlantillaIns> findAllLike(PlantillaIns plantillaIns,
			Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the PlantillaIns table.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return
	 */
	void remove(PlantillaIns plantillaIns);

	/**
	 * Deletes multiple rows in the PlantillaIns table.
	 * 
	 * @param plantillaInsList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<PlantillaIns> plantillaInsList);

}
